"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INDICATOR_CUSTOM_METRIC = exports.INDICATOR_CUSTOM_KQL = exports.INDICATOR_APM_LATENCY = exports.INDICATOR_APM_AVAILABILITY = exports.BUDGETING_METHOD_TIMESLICES = exports.BUDGETING_METHOD_OCCURRENCES = void 0;
exports.toDurationAdverbLabel = toDurationAdverbLabel;
exports.toDurationLabel = toDurationLabel;
exports.toIndicatorTypeLabel = toIndicatorTypeLabel;
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _duration = require("./duration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDICATOR_CUSTOM_KQL = _i18n.i18n.translate('xpack.observability.slo.indicators.customKql', {
  defaultMessage: 'Custom KQL'
});
exports.INDICATOR_CUSTOM_KQL = INDICATOR_CUSTOM_KQL;
const INDICATOR_CUSTOM_METRIC = _i18n.i18n.translate('xpack.observability.slo.indicators.customMetric', {
  defaultMessage: 'Custom Metric'
});
exports.INDICATOR_CUSTOM_METRIC = INDICATOR_CUSTOM_METRIC;
const INDICATOR_APM_LATENCY = _i18n.i18n.translate('xpack.observability.slo.indicators.apmLatency', {
  defaultMessage: 'APM latency'
});
exports.INDICATOR_APM_LATENCY = INDICATOR_APM_LATENCY;
const INDICATOR_APM_AVAILABILITY = _i18n.i18n.translate('xpack.observability.slo.indicators.apmAvailability', {
  defaultMessage: 'APM availability'
});
exports.INDICATOR_APM_AVAILABILITY = INDICATOR_APM_AVAILABILITY;
function toIndicatorTypeLabel(indicatorType) {
  switch (indicatorType) {
    case 'sli.kql.custom':
      return INDICATOR_CUSTOM_KQL;
    case 'sli.apm.transactionDuration':
      return INDICATOR_APM_LATENCY;
    case 'sli.apm.transactionErrorRate':
      return INDICATOR_APM_AVAILABILITY;
    case 'sli.metric.custom':
      return INDICATOR_CUSTOM_METRIC;
    default:
      (0, _std.assertNever)(indicatorType);
  }
}
const BUDGETING_METHOD_OCCURRENCES = _i18n.i18n.translate('xpack.observability.slo.budgetingMethod.occurrences', {
  defaultMessage: 'Occurrences'
});
exports.BUDGETING_METHOD_OCCURRENCES = BUDGETING_METHOD_OCCURRENCES;
const BUDGETING_METHOD_TIMESLICES = _i18n.i18n.translate('xpack.observability.slo.budgetingMethod.timeslices', {
  defaultMessage: 'Timeslices'
});
exports.BUDGETING_METHOD_TIMESLICES = BUDGETING_METHOD_TIMESLICES;
function toDurationLabel(durationStr) {
  const duration = (0, _duration.toDuration)(durationStr);
  switch (duration.unit) {
    case 'm':
      return _i18n.i18n.translate('xpack.observability.slo.duration.minute', {
        defaultMessage: '{duration, plural, one {1 minute} other {# minutes}}',
        values: {
          duration: duration.value
        }
      });
    case 'h':
      return _i18n.i18n.translate('xpack.observability.slo.duration.hour', {
        defaultMessage: '{duration, plural, one {1 hour} other {# hours}}',
        values: {
          duration: duration.value
        }
      });
    case 'd':
      return _i18n.i18n.translate('xpack.observability.slo.duration.day', {
        defaultMessage: '{duration, plural, one {1 day} other {# days}}',
        values: {
          duration: duration.value
        }
      });
    case 'w':
      return _i18n.i18n.translate('xpack.observability.slo.duration.week', {
        defaultMessage: '{duration, plural, one {1 week} other {# weeks}}',
        values: {
          duration: duration.value
        }
      });
    case 'M':
      return _i18n.i18n.translate('xpack.observability.slo.duration.month', {
        defaultMessage: '{duration, plural, one {1 month} other {# months}}',
        values: {
          duration: duration.value
        }
      });
    case 'Y':
      return _i18n.i18n.translate('xpack.observability.slo.duration.year', {
        defaultMessage: '{duration, plural, one {1 year} other {# years}}',
        values: {
          duration: duration.value
        }
      });
  }
}
function toDurationAdverbLabel(durationStr) {
  const duration = (0, _duration.toDuration)(durationStr);
  switch (duration.unit) {
    case 'm':
      return _i18n.i18n.translate('xpack.observability.slo.duration.minutely', {
        defaultMessage: 'Minutely'
      });
    case 'h':
      return _i18n.i18n.translate('xpack.observability.slo.duration.hourly', {
        defaultMessage: 'Hourly'
      });
    case 'd':
      return _i18n.i18n.translate('xpack.observability.slo.duration.daily', {
        defaultMessage: 'Daily'
      });
    case 'w':
      return _i18n.i18n.translate('xpack.observability.slo.duration.weekly', {
        defaultMessage: 'Weekly'
      });
    case 'M':
      return _i18n.i18n.translate('xpack.observability.slo.duration.monthly', {
        defaultMessage: 'Monthly'
      });
    case 'Y':
      return _i18n.i18n.translate('xpack.observability.slo.duration.yearly', {
        defaultMessage: 'Yearly'
      });
  }
}