"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAbsoluteDateRange = getAbsoluteDateRange;
exports.getAbsoluteTime = getAbsoluteTime;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAbsoluteTime(range, opts = {}) {
  const parsed = _datemath.default.parse(range, opts);
  if (parsed) {
    return parsed.valueOf();
  }
}
function getAbsoluteDateRange({
  rangeFrom,
  rangeTo
}) {
  if (!rangeFrom || !rangeTo) {
    return {
      start: undefined,
      end: undefined
    };
  }
  const absoluteStart = getAbsoluteTime(rangeFrom);
  const absoluteEnd = getAbsoluteTime(rangeTo, {
    roundUp: true
  });
  if (!absoluteStart || !absoluteEnd) {
    throw new Error('Could not parse date range');
  }
  return {
    start: new Date(absoluteStart).toISOString(),
    end: new Date(absoluteEnd).toISOString()
  };
}