"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlosPage = SlosPage;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_license = require("../../hooks/use_license");
var _use_capabilities = require("../../hooks/slo/use_capabilities");
var _use_fetch_slo_list = require("../../hooks/slo/use_fetch_slo_list");
var _slo_list = require("./components/slo_list");
var _auto_refresh_button = require("./components/auto_refresh_button");
var _header_title = require("./components/header_title");
var _feedback_button = require("../../components/slo/feedback_button/feedback_button");
var _paths = require("../../config/paths");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SlosPage() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const {
    isInitialLoading,
    isLoading,
    isError,
    sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)();
  const {
    total
  } = sloList || {};
  const [isAutoRefreshing, setIsAutoRefreshing] = (0, _react.useState)(true);
  (0, _public.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.observability.slos),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.slosLinkText', {
      defaultMessage: 'SLOs'
    })
  }]);
  (0, _react.useEffect)(() => {
    if (!isLoading && total === 0 || hasAtLeast('platinum') === false || isError) {
      navigateToUrl(basePath.prepend(_paths.paths.observability.slosWelcome));
    }
  }, [basePath, hasAtLeast, isError, isLoading, navigateToUrl, total]);
  const handleClickCreateSlo = () => {
    navigateToUrl(basePath.prepend(_paths.paths.observability.sloCreate));
  };
  const handleToggleAutoRefresh = () => {
    setIsAutoRefreshing(!isAutoRefreshing);
  };
  if (isInitialLoading) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_header_title.HeaderTitle, null),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        "data-test-subj": "slosPageCreateNewSloButton",
        disabled: !hasWriteCapabilities,
        fill: true,
        onClick: handleClickCreateSlo
      }, _i18n.i18n.translate('xpack.observability.slo.sloList.pageHeader.createNewButtonLabel', {
        defaultMessage: 'Create new SLO'
      })), /*#__PURE__*/_react.default.createElement(_auto_refresh_button.AutoRefreshButton, {
        isAutoRefreshing: isAutoRefreshing,
        onClick: handleToggleAutoRefresh
      }), /*#__PURE__*/_react.default.createElement(_feedback_button.FeedbackButton, null)],
      bottomBorder: false
    },
    "data-test-subj": "slosPage"
  }, /*#__PURE__*/_react.default.createElement(_slo_list.SloList, {
    autoRefresh: isAutoRefreshing
  }));
}