"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloTimeWindowBadge = SloTimeWindowBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _uiTheme = require("@kbn/ui-theme");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _duration = require("../../../../utils/slo/duration");
var _labels = require("../../../../utils/slo/labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloTimeWindowBadge({
  slo
}) {
  const unit = slo.timeWindow.duration.slice(-1);
  if (_sloSchema.rollingTimeWindowTypeSchema.is(slo.timeWindow.type)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: _uiTheme.euiLightVars.euiColorDisabled,
      iconType: "editorItemAlignRight",
      iconSide: "left"
    }, (0, _labels.toDurationLabel)(slo.timeWindow.duration)));
  }
  const unitMoment = (0, _duration.toMomentUnitOfTime)(unit);
  const now = _moment.default.utc();
  const periodStart = now.clone().startOf(unitMoment);
  const periodEnd = now.clone().endOf(unitMoment);
  const totalDurationInDays = periodEnd.diff(periodStart, 'days') + 1;
  const elapsedDurationInDays = now.diff(periodStart, 'days') + 1;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: _uiTheme.euiLightVars.euiColorDisabled,
    iconType: "calendar",
    iconSide: "left"
  }, _i18n.i18n.translate('xpack.observability.slo.slo.timeWindow.calendar', {
    defaultMessage: '{elapsed}/{total} days',
    values: {
      elapsed: Math.min(elapsedDurationInDays, totalDurationInDays),
      total: totalDurationInDays
    }
  })));
}