"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomMetricIndicatorTypeForm = CustomMetricIndicatorTypeForm;
Object.defineProperty(exports, "NEW_CUSTOM_METRIC", {
  enumerable: true,
  get: function () {
    return _metric_indicator.NEW_CUSTOM_METRIC;
  }
});
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_fetch_index_pattern_fields = require("../../../../hooks/slo/use_fetch_index_pattern_fields");
var _query_builder = require("../common/query_builder");
var _index_selection = require("../custom_common/index_selection");
var _metric_indicator = require("./metric_indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomMetricIndicatorTypeForm() {
  const {
    control,
    watch,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const {
    isLoading,
    data: indexFields
  } = (0, _use_fetch_index_pattern_fields.useFetchIndexPatternFields)(watch('indicator.params.index'));
  const timestampFields = (indexFields !== null && indexFields !== void 0 ? indexFields : []).filter(field => field.type === 'date');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_selection.IndexSelection, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.timestampField.label', {
      defaultMessage: 'Timestamp field'
    }),
    isInvalid: getFieldState('indicator.params.timestampField').invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "indicator.params.timestampField",
    defaultValue: "",
    rules: {
      required: true
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      async: true,
      placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.timestampField.placeholder', {
        defaultMessage: 'Select a timestamp field'
      }),
      "aria-label": _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.timestampField.placeholder', {
        defaultMessage: 'Select a timestamp field'
      }),
      "data-test-subj": "customMetricIndicatorFormTimestampFieldSelect",
      isClearable: true,
      isDisabled: !watch('indicator.params.index'),
      isInvalid: fieldState.invalid,
      isLoading: !!watch('indicator.params.index') && isLoading,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      options: createOptions(timestampFields),
      selectedOptions: !!watch('indicator.params.index') && !!field.value && timestampFields.some(timestampField => timestampField.name === field.value) ? [{
        value: field.value,
        label: field.value,
        'data-test-subj': `customMetricIndicatorFormTimestampFieldSelectedValue`
      }] : [],
      singleSelection: {
        asPlainText: true
      }
    }))
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "customMetricIndicatorFormQueryFilterInput",
    indexPatternString: watch('indicator.params.index'),
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.queryFilter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.customFilter', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.customFilter.tooltip', {
        defaultMessage: 'This KQL query can be used to filter the documents with some relevant criteria.'
      }),
      position: "top"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_metric_indicator.MetricIndicator, {
    type: "good",
    indexFields: indexFields,
    isLoadingIndex: isLoading,
    equationLabel: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.goodEquationLabel', {
      defaultMessage: 'Good equation'
    }),
    metricLabel: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.goodMetricLabel', {
      defaultMessage: 'Good metric'
    }),
    metricTooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.goodMetric.tooltip', {
        defaultMessage: 'This data from this field will be aggregated with the "sum" aggregation.'
      }),
      position: "top"
    }),
    equationTooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.goodEquation.tooltip', {
        defaultMessage: 'This supports basic math (A + B / C) and boolean logic (A < B ? A : B).'
      }),
      position: "top"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_metric_indicator.MetricIndicator, {
    type: "total",
    indexFields: indexFields,
    isLoadingIndex: isLoading,
    equationLabel: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.totalEquationLabel', {
      defaultMessage: 'Total equation'
    }),
    metricLabel: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.totalMetricLabel', {
      defaultMessage: 'Total metric'
    }),
    metricTooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.totalMetric.tooltip', {
        defaultMessage: 'This data from this field will be aggregated with the "sum" aggregation.'
      }),
      position: "top"
    }),
    equationTooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.totalEquation.tooltip', {
        defaultMessage: 'This supports basic math (A + B / C) and boolean logic (A < B ? A : B).'
      }),
      position: "top"
    })
  })));
}
function createOptions(fields) {
  return fields.map(field => ({
    label: field.name,
    value: field.name
  })).sort((a, b) => String(a.label).localeCompare(b.label));
}