"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomKqlIndicatorTypeForm = CustomKqlIndicatorTypeForm;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_fetch_index_pattern_fields = require("../../../../hooks/slo/use_fetch_index_pattern_fields");
var _data_preview_chart = require("../common/data_preview_chart");
var _query_builder = require("../common/query_builder");
var _index_selection = require("../custom_common/index_selection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomKqlIndicatorTypeForm() {
  const {
    control,
    watch,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const index = watch('indicator.params.index');
  const {
    isLoading,
    data: indexFields
  } = (0, _use_fetch_index_pattern_fields.useFetchIndexPatternFields)(index);
  const timestampFields = (indexFields !== null && indexFields !== void 0 ? indexFields : []).filter(field => field.type === 'date');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_selection.IndexSelection, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.timestampField.label', {
      defaultMessage: 'Timestamp field'
    }),
    isInvalid: getFieldState('indicator.params.timestampField').invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "indicator.params.timestampField",
    defaultValue: "",
    rules: {
      required: true
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      async: true,
      placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.timestampField.placeholder', {
        defaultMessage: 'Select a timestamp field'
      }),
      "aria-label": _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.timestampField.placeholder', {
        defaultMessage: 'Select a timestamp field'
      }),
      "data-test-subj": "customKqlIndicatorFormTimestampFieldSelect",
      isClearable: true,
      isDisabled: !index,
      isInvalid: fieldState.invalid,
      isLoading: !!index && isLoading,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      options: createOptions(timestampFields),
      selectedOptions: !!index && !!field.value && timestampFields.some(timestampField => timestampField.name === field.value) ? [{
        value: field.value,
        label: field.value
      }] : [],
      singleSelection: {
        asPlainText: true
      }
    }))
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "customKqlIndicatorFormQueryFilterInput",
    indexPatternString: watch('indicator.params.index'),
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.queryFilter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.customFilter', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.customFilter.tooltip', {
        defaultMessage: 'This KQL query can be used to filter the documents with some relevant criteria.'
      }),
      position: "top"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "customKqlIndicatorFormGoodQueryInput",
    indexPatternString: watch('indicator.params.index'),
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.goodQuery', {
      defaultMessage: 'Good query'
    }),
    name: "indicator.params.good",
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.goodQueryPlaceholder', {
      defaultMessage: 'Define the good events'
    }),
    required: true,
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.goodQuery.tooltip', {
        defaultMessage: 'This KQL query should return a subset of events that are considered "good" or "successful" for the purpose of calculating the SLO. The query should filter events based on some relevant criteria, such as status codes, error messages, or other relevant fields.'
      }),
      position: "top"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "customKqlIndicatorFormTotalQueryInput",
    indexPatternString: watch('indicator.params.index'),
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.totalQuery', {
      defaultMessage: 'Total query'
    }),
    name: "indicator.params.total",
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.totalQueryPlaceholder', {
      defaultMessage: 'Define the total events'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customKql.totalQuery.tooltip', {
        defaultMessage: 'This KQL query should return all events that are relevant to the SLO calculation, including both good and bad events.'
      }),
      position: "top"
    })
  })), /*#__PURE__*/_react.default.createElement(_data_preview_chart.DataPreviewChart, null));
}
function createOptions(fields) {
  return fields.map(field => ({
    label: field.name,
    value: field.name
  })).sort((a, b) => String(a.label).localeCompare(b.label));
}