"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmAvailabilityIndicatorTypeForm = ApmAvailabilityIndicatorTypeForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _field_selector = require("../apm_common/field_selector");
var _query_builder = require("../common/query_builder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ApmAvailabilityIndicatorTypeForm() {
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    allowAllOption: false,
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apmAvailability.serviceName', {
      defaultMessage: 'Service name'
    }),
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apmAvailability.serviceName.placeholder', {
      defaultMessage: 'Select the APM service'
    }),
    fieldName: "service.name",
    name: "indicator.params.service",
    dataTestSubj: "apmAvailabilityServiceSelector",
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apm.serviceName.tooltip', {
        defaultMessage: 'This is the APM service monitored by this SLO.'
      }),
      position: "top"
    })
  }), /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apmAvailability.serviceEnvironment', {
      defaultMessage: 'Service environment'
    }),
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apmAvailability.serviceEnvironment.placeholder', {
      defaultMessage: 'Select the environment'
    }),
    fieldName: "service.environment",
    name: "indicator.params.environment",
    dataTestSubj: "apmAvailabilityEnvironmentSelector"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apmAvailability.transactionType', {
      defaultMessage: 'Transaction type'
    }),
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apmAvailability.transactionType.placeholder', {
      defaultMessage: 'Select the transaction type'
    }),
    fieldName: "transaction.type",
    name: "indicator.params.transactionType",
    dataTestSubj: "apmAvailabilityTransactionTypeSelector"
  }), /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apmAvailability.transactionName', {
      defaultMessage: 'Transaction name'
    }),
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apmAvailability.transactionName.placeholder', {
      defaultMessage: 'Select the transaction name'
    }),
    fieldName: "transaction.name",
    name: "indicator.params.transactionName",
    dataTestSubj: "apmAvailabilityTransactionNameSelector"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "apmLatencyFilterInput",
    indexPatternString: watch('indicator.params.index'),
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apmLatency.filter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apmLatency.filter.placeholder', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.apm.filter.tooltip', {
        defaultMessage: 'This KQL query is used to filter the APM metrics on some relevant criteria for this SLO.'
      }),
      position: "top"
    })
  }))));
}