"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WideChart = WideChart;
var _charts = require("@elastic/charts");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/charts-plugin/public");
var _kibana_react = require("../../../utils/kibana_react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function WideChart({
  chart,
  data,
  id,
  isLoading,
  state
}) {
  const {
    charts,
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const theme = charts.theme.useChartsTheme();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dateFormat = uiSettings.get('dateFormat');
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const color = state === 'error' ? euiTheme.colors.danger : euiTheme.colors.success;
  const ChartComponent = chart === 'area' ? _charts.AreaSeries : _charts.LineSeries;
  const chartRef = (0, _react.useRef)(null);
  const handleCursorUpdate = (0, _public.useActiveCursor)(charts.activeCursor, chartRef, {
    isDateHistogram: true
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "m",
      mono: true,
      "data-test-subj": "wideChartLoading"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 150,
      width: '100%'
    },
    ref: chartRef
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.VerticalCursor
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: false,
    theme: [theme],
    noResults: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visualizeApp",
      size: "l",
      color: "subdued",
      title: "no results"
    }),
    onPointerUpdate: handleCursorUpdate,
    externalPointerEvents: {
      tooltip: {
        visible: true
      }
    },
    pointerUpdateDebounce: 0,
    pointerUpdateTrigger: 'x'
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: d => (0, _moment.default)(d).format(dateFormat)
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    ticks: 4,
    position: _charts.Position.Left,
    tickFormat: d => (0, _numeral.default)(d).format(percentFormat)
  }), /*#__PURE__*/_react.default.createElement(ChartComponent, {
    color: color,
    data: data,
    fit: _charts.Fit.Nearest,
    id: id,
    lineSeriesStyle: {
      line: {
        strokeWidth: 1
      },
      point: {
        visible: false
      }
    },
    xAccessor: "key",
    xScaleType: _charts.ScaleType.Time,
    yAccessors: ['value'],
    yScaleType: _charts.ScaleType.Linear,
    yNice: true
  }));
}