"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRates = BurnRates;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_fetch_slo_burn_rates = require("../../../hooks/slo/use_fetch_slo_burn_rates");
var _burn_rate_window = require("./burn_rate_window");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CRITICAL_LONG = 'CRITICAL_LONG';
const CRITICAL_SHORT = 'CRITICAL_SHORT';
const HIGH_LONG = 'HIGH_LONG';
const HIGH_SHORT = 'HIGH_SHORT';
const MEDIUM_LONG = 'MEDIUM_LONG';
const MEDIUM_SHORT = 'MEDIUM_SHORT';
const LOW_LONG = 'LOW_LONG';
const LOW_SHORT = 'LOW_SHORT';
const WINDOWS = [{
  name: CRITICAL_LONG,
  duration: '1h'
}, {
  name: CRITICAL_SHORT,
  duration: '5m'
}, {
  name: HIGH_LONG,
  duration: '6h'
}, {
  name: HIGH_SHORT,
  duration: '30m'
}, {
  name: MEDIUM_LONG,
  duration: '24h'
}, {
  name: MEDIUM_SHORT,
  duration: '120m'
}, {
  name: LOW_LONG,
  duration: '72h'
}, {
  name: LOW_SHORT,
  duration: '360m'
}];
function getSliAndBurnRate(name, burnRates) {
  const data = burnRates.find(rate => rate.name === name);
  if (!data) {
    return {
      burnRate: null,
      sli: null
    };
  }
  return {
    burnRate: data.burnRate,
    sli: data.sli
  };
}
function BurnRates({
  slo,
  isAutoRefreshing
}) {
  var _data$burnRates, _data$burnRates2, _data$burnRates3, _data$burnRates4, _data$burnRates5, _data$burnRates6, _data$burnRates7, _data$burnRates8;
  const {
    isLoading,
    data
  } = (0, _use_fetch_slo_burn_rates.useFetchSloBurnRates)({
    sloId: slo.id,
    shouldRefetch: isAutoRefreshing,
    windows: WINDOWS
  });
  const criticalWindowParams = {
    title: _i18n.i18n.translate('xpack.observability.slo.burnRate.criticalTitle', {
      defaultMessage: 'Critical burn rate'
    }),
    target: 14.4,
    longWindow: {
      label: _i18n.i18n.translate('xpack.observability.slo.burnRate.criticalLongLabel', {
        defaultMessage: '1 hour'
      }),
      ...getSliAndBurnRate(CRITICAL_LONG, (_data$burnRates = data === null || data === void 0 ? void 0 : data.burnRates) !== null && _data$burnRates !== void 0 ? _data$burnRates : [])
    },
    shortWindow: {
      label: _i18n.i18n.translate('xpack.observability.slo.burnRate.criticalShortLabel', {
        defaultMessage: '5 minute'
      }),
      ...getSliAndBurnRate(CRITICAL_SHORT, (_data$burnRates2 = data === null || data === void 0 ? void 0 : data.burnRates) !== null && _data$burnRates2 !== void 0 ? _data$burnRates2 : [])
    }
  };
  const highWindowParams = {
    title: _i18n.i18n.translate('xpack.observability.slo.burnRate.highTitle', {
      defaultMessage: 'High burn rate'
    }),
    target: 6,
    longWindow: {
      label: _i18n.i18n.translate('xpack.observability.slo.burnRate.highLongLabel', {
        defaultMessage: '6 hour'
      }),
      ...getSliAndBurnRate(HIGH_LONG, (_data$burnRates3 = data === null || data === void 0 ? void 0 : data.burnRates) !== null && _data$burnRates3 !== void 0 ? _data$burnRates3 : [])
    },
    shortWindow: {
      label: _i18n.i18n.translate('xpack.observability.slo.burnRate.highShortLabel', {
        defaultMessage: '30 minute'
      }),
      ...getSliAndBurnRate(HIGH_SHORT, (_data$burnRates4 = data === null || data === void 0 ? void 0 : data.burnRates) !== null && _data$burnRates4 !== void 0 ? _data$burnRates4 : [])
    }
  };
  const mediumWindowParams = {
    title: _i18n.i18n.translate('xpack.observability.slo.burnRate.mediumTitle', {
      defaultMessage: 'Medium burn rate'
    }),
    target: 3,
    longWindow: {
      label: _i18n.i18n.translate('xpack.observability.slo.burnRate.mediumLongLabel', {
        defaultMessage: '24 hours'
      }),
      ...getSliAndBurnRate(MEDIUM_LONG, (_data$burnRates5 = data === null || data === void 0 ? void 0 : data.burnRates) !== null && _data$burnRates5 !== void 0 ? _data$burnRates5 : [])
    },
    shortWindow: {
      label: _i18n.i18n.translate('xpack.observability.slo.burnRate.mediumShortLabel', {
        defaultMessage: '2 hours'
      }),
      ...getSliAndBurnRate(MEDIUM_SHORT, (_data$burnRates6 = data === null || data === void 0 ? void 0 : data.burnRates) !== null && _data$burnRates6 !== void 0 ? _data$burnRates6 : [])
    }
  };
  const lowWindowParams = {
    title: _i18n.i18n.translate('xpack.observability.slo.burnRate.lowTitle', {
      defaultMessage: 'Low burn rate'
    }),
    target: 1,
    longWindow: {
      label: _i18n.i18n.translate('xpack.observability.slo.burnRate.lowLongLabel', {
        defaultMessage: '3 days'
      }),
      ...getSliAndBurnRate(LOW_LONG, (_data$burnRates7 = data === null || data === void 0 ? void 0 : data.burnRates) !== null && _data$burnRates7 !== void 0 ? _data$burnRates7 : [])
    },
    shortWindow: {
      label: _i18n.i18n.translate('xpack.observability.slo.burnRate.lowShortLabel', {
        defaultMessage: '6 hours'
      }),
      ...getSliAndBurnRate(LOW_SHORT, (_data$burnRates8 = data === null || data === void 0 ? void 0 : data.burnRates) !== null && _data$burnRates8 !== void 0 ? _data$burnRates8 : [])
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "burnRatePanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observability.slo.burnRate.title', {
    defaultMessage: 'Burn rate windows'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.observability.slo.burnRate.technicalPreviewBadgeTitle', {
      defaultMessage: 'Technical Preview'
    }),
    size: "s",
    tooltipPosition: "bottom",
    tooltipContent: _i18n.i18n.translate('xpack.observability.slo.burnRate.technicalPreviewBadgeDescription', {
      defaultMessage: 'This functionality is in technical preview and is subject to change or may be removed in future versions. The design and code is less mature than official generally available features and is being provided as-is with no warranties. Technical preview features are not subject to the support service level agreement of official generally available features.'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4
  }, /*#__PURE__*/_react.default.createElement(_burn_rate_window.BurnRateWindow, (0, _extends2.default)({}, criticalWindowParams, {
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_burn_rate_window.BurnRateWindow, (0, _extends2.default)({}, highWindowParams, {
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_burn_rate_window.BurnRateWindow, (0, _extends2.default)({}, mediumWindowParams, {
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_burn_rate_window.BurnRateWindow, (0, _extends2.default)({}, lowWindowParams, {
    isLoading: isLoading
  }))));
}