"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRateWindow = BurnRateWindow;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUBDUED = 'subdued';
const DANGER = 'danger';
const SUCCESS = 'success';
const WARNING = 'warning';
function getColorBasedOnBurnRate(target, burnRate, sli) {
  if (burnRate === null || sli === null || sli < 0) {
    return SUBDUED;
  }
  if (burnRate > target) {
    return DANGER;
  }
  return SUCCESS;
}
function BurnRateWindow({
  title,
  target,
  longWindow,
  shortWindow,
  isLoading,
  size = 's'
}) {
  const longWindowColor = getColorBasedOnBurnRate(target, longWindow.burnRate, longWindow.sli);
  const shortWindowColor = getColorBasedOnBurnRate(target, shortWindow.burnRate, shortWindow.sli);
  const overallColor = longWindowColor === DANGER && shortWindowColor === DANGER ? DANGER : [longWindowColor, shortWindowColor].includes(DANGER) ? WARNING : longWindowColor === SUBDUED && shortWindowColor === SUBDUED ? SUBDUED : SUCCESS;
  const isLongWindowValid = longWindow.burnRate != null && longWindow.sli != null && longWindow.sli >= 0;
  const isShortWindowValid = shortWindow.burnRate != null && shortWindow.sli != null && shortWindow.sli >= 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: overallColor
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: overallColor
  }, /*#__PURE__*/_react.default.createElement("h5", null, title, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.observability.slo.burnRateWindow.thresholdTip', {
      defaultMessage: 'Threshold is {target}x',
      values: {
        target
      }
    }),
    position: "top"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: isLongWindowValid ? `${(0, _numeral.default)(longWindow.burnRate).format('0.[00]')}x` : '--',
    titleColor: longWindowColor,
    titleSize: size,
    textAlign: "left",
    isLoading: isLoading,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: longWindowColor
    }, /*#__PURE__*/_react.default.createElement("span", null, longWindow.label))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: isShortWindowValid ? `${(0, _numeral.default)(shortWindow.burnRate).format('0.[00]')}x` : '--',
    titleColor: shortWindowColor,
    titleSize: size,
    textAlign: "left",
    isLoading: isLoading,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: shortWindowColor
    }, /*#__PURE__*/_react.default.createElement("span", null, shortWindow.label))
  }))));
}