"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityStatus = ObservabilityStatus;
var _react = _interopRequireDefault(require("react"));
var _kibana_react = require("../../../../utils/kibana_react");
var _use_has_data = require("../../../../hooks/use_has_data");
var _observability_status_boxes = require("./observability_status_boxes");
var _content = require("./content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ObservabilityStatus() {
  const {
    http,
    docLinks
  } = (0, _kibana_react.useKibana)().services;
  const {
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  const content = (0, _content.getContent)(http, docLinks);
  const boxes = content.map(app => {
    var _hasDataMap$app$id$ha, _hasDataMap$app$id;
    return {
      ...app,
      hasData: (_hasDataMap$app$id$ha = (_hasDataMap$app$id = hasDataMap[app.id]) === null || _hasDataMap$app$id === void 0 ? void 0 : _hasDataMap$app$id.hasData) !== null && _hasDataMap$app$id$ha !== void 0 ? _hasDataMap$app$id$ha : false,
      modules: []
    };
  });
  return /*#__PURE__*/_react.default.createElement(_observability_status_boxes.ObservabilityStatusBoxes, {
    boxes: boxes
  });
}