"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesPage = CasesPage;
var _react = _interopRequireDefault(require("react"));
var _use_get_user_cases_permissions = require("../../hooks/use_get_user_cases_permissions");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_has_data = require("../../hooks/use_has_data");
var _cases = require("./components/cases");
var _loading_observability = require("../../components/loading_observability");
var _feature_no_permissions = require("./components/feature_no_permissions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CasesPage() {
  const userCasesPermissions = (0, _use_get_user_cases_permissions.useGetUserCasesPermissions)();
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    hasAnyData,
    isAllRequestsComplete
  } = (0, _use_has_data.useHasData)();
  if (!hasAnyData && !isAllRequestsComplete) {
    return /*#__PURE__*/_react.default.createElement(_loading_observability.LoadingObservability, null);
  }
  return userCasesPermissions.read ? /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    isPageDataLoaded: true,
    "data-test-subj": "o11yCasesPage"
  }, /*#__PURE__*/_react.default.createElement(_cases.Cases, {
    permissions: userCasesPermissions
  })) : /*#__PURE__*/_react.default.createElement(_feature_no_permissions.CaseFeatureNoPermissions, null);
}