"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetUserCasesPermissions = useGetUserCasesPermissions;
var _react = require("react");
var _kibana_react = require("../utils/kibana_react");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetUserCasesPermissions() {
  const [casesPermissions, setCasesPermissions] = (0, _react.useState)({
    all: false,
    read: false,
    create: false,
    update: false,
    delete: false,
    push: false
  });
  const uiCapabilities = (0, _kibana_react.useKibana)().services.application.capabilities;
  const casesCapabilities = (0, _kibana_react.useKibana)().services.cases.helpers.getUICapabilities(uiCapabilities[_common.casesFeatureId]);
  (0, _react.useEffect)(() => {
    setCasesPermissions({
      all: casesCapabilities.all,
      create: casesCapabilities.create,
      read: casesCapabilities.read,
      update: casesCapabilities.update,
      delete: casesCapabilities.delete,
      push: casesCapabilities.push
    });
  }, [casesCapabilities.all, casesCapabilities.create, casesCapabilities.read, casesCapabilities.update, casesCapabilities.delete, casesCapabilities.push]);
  return casesPermissions;
}