"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchRule = useFetchRule;
var _react = require("react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _translations = require("../pages/rule_details/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchRule({
  ruleId,
  http
}) {
  const [ruleSummary, setRuleSummary] = (0, _react.useState)({
    isRuleLoading: true,
    rule: undefined,
    errorRule: undefined
  });
  const fetchRuleSummary = (0, _react.useCallback)(async () => {
    try {
      if (!ruleId) return;
      const rule = await (0, _public.loadRule)({
        http,
        ruleId
      });
      setRuleSummary(oldState => ({
        ...oldState,
        isRuleLoading: false,
        rule
      }));
    } catch (error) {
      setRuleSummary(oldState => ({
        ...oldState,
        isRuleLoading: false,
        errorRule: (0, _translations.RULE_LOAD_ERROR)(error instanceof Error ? error.message : typeof error === 'string' ? error : '')
      }));
    }
  }, [ruleId, http]);
  (0, _react.useEffect)(() => {
    fetchRuleSummary();
  }, [fetchRuleSummary]);
  return {
    ...ruleSummary,
    reloadRule: fetchRuleSummary
  };
}