"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloDetails = useFetchSloDetails;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../../utils/kibana_react");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LONG_REFETCH_INTERVAL = 1000 * 60; // 1 minute

function useFetchSloDetails({
  sloId,
  shouldRefetch
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.detail(sloId),
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await http.get(`/api/observability/slos/${sloId}`, {
          query: {},
          signal
        });
        return response;
      } catch (error) {
        // ignore error for retrieving slos
      }
    },
    keepPreviousData: true,
    enabled: Boolean(sloId),
    refetchInterval: shouldRefetch ? LONG_REFETCH_INTERVAL : undefined,
    refetchOnWindowFocus: false
  });
  return {
    slo: data,
    isLoading,
    isInitialLoading,
    isRefetching,
    isSuccess,
    isError,
    refetch
  };
}