"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchIndexPatternFields = useFetchIndexPatternFields;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchIndexPatternFields(indexPattern) {
  const {
    dataViews
  } = (0, _kibana_react.useKibana)().services;
  const {
    isLoading,
    isError,
    isSuccess,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchIndexPatternFields', indexPattern],
    queryFn: async ({
      signal
    }) => {
      if (!indexPattern) {
        return [];
      }
      try {
        return await dataViews.getFieldsForWildcard({
          pattern: indexPattern
        });
      } catch (error) {
        throw new Error(`Something went wrong. Error: ${error}`);
      }
    },
    retry: false,
    refetchOnWindowFocus: false,
    enabled: Boolean(indexPattern)
  });
  return {
    isLoading,
    isError,
    isSuccess,
    data
  };
}