"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteSlo = useDeleteSlo;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../utils/kibana_react");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDeleteSlo() {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)(['deleteSlo'], ({
    id
  }) => {
    try {
      return http.delete(`/api/observability/slos/${id}`);
    } catch (error) {
      return Promise.reject(`Something went wrong: ${String(error)}`);
    }
  }, {
    onMutate: async slo => {
      var _queriesData$at, _previousData$page, _previousData$perPage, _previousData$results, _previousData$results2;
      await queryClient.cancelQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      const queriesData = queryClient.getQueriesData({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      const [queryKey, previousData] = (_queriesData$at = queriesData === null || queriesData === void 0 ? void 0 : queriesData.at(0)) !== null && _queriesData$at !== void 0 ? _queriesData$at : [];
      const optimisticUpdate = {
        page: (_previousData$page = previousData === null || previousData === void 0 ? void 0 : previousData.page) !== null && _previousData$page !== void 0 ? _previousData$page : 1,
        perPage: (_previousData$perPage = previousData === null || previousData === void 0 ? void 0 : previousData.perPage) !== null && _previousData$perPage !== void 0 ? _previousData$perPage : 25,
        total: previousData !== null && previousData !== void 0 && previousData.total ? previousData.total - 1 : 0,
        results: (_previousData$results = previousData === null || previousData === void 0 ? void 0 : (_previousData$results2 = previousData.results) === null || _previousData$results2 === void 0 ? void 0 : _previousData$results2.filter(result => result.id !== slo.id)) !== null && _previousData$results !== void 0 ? _previousData$results : []
      };
      if (queryKey) {
        queryClient.setQueryData(queryKey, optimisticUpdate);
      }
      return {
        previousData,
        queryKey
      };
    },
    // If the mutation fails, use the context returned from onMutate to roll back
    onError: (_err, {
      name
    }, context) => {
      if (context !== null && context !== void 0 && context.previousData && context !== null && context !== void 0 && context.queryKey) {
        queryClient.setQueryData(context.queryKey, context.previousData);
      }
      toasts.addDanger(_i18n.i18n.translate('xpack.observability.slo.slo.delete.errorNotification', {
        defaultMessage: 'Failed to delete {name}',
        values: {
          name
        }
      }));
    },
    onSuccess: (_data, {
      name
    }) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observability.slo.slo.delete.successNotification', {
        defaultMessage: 'Deleted {name}',
        values: {
          name
        }
      }));
    },
    onSettled: () => {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
    }
  });
}