"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sloKeys = exports.compositeSloKeys = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sloKeys = {
  all: ['slo'],
  lists: () => [...sloKeys.all, 'list'],
  list: filters => [...sloKeys.lists(), filters],
  details: () => [...sloKeys.all, 'details'],
  detail: sloId => [...sloKeys.details(), sloId],
  rules: () => [...sloKeys.all, 'rules'],
  rule: sloIds => [...sloKeys.rules(), sloIds],
  activeAlerts: () => [...sloKeys.all, 'activeAlerts'],
  activeAlert: sloIds => [...sloKeys.activeAlerts(), sloIds],
  historicalSummaries: () => [...sloKeys.all, 'historicalSummary'],
  historicalSummary: sloIds => [...sloKeys.historicalSummaries(), sloIds],
  globalDiagnosis: () => [...sloKeys.all, 'globalDiagnosis'],
  burnRates: sloId => [...sloKeys.all, 'burnRates', sloId],
  preview: indicator => [...sloKeys.all, 'preview', indicator]
};
exports.sloKeys = sloKeys;
const compositeSloKeys = {
  all: ['compositeSlo'],
  lists: () => [...compositeSloKeys.all, 'list'],
  list: filters => [...compositeSloKeys.lists(), filters],
  details: () => [...compositeSloKeys.all, 'details'],
  detail: sloId => [...compositeSloKeys.details(), sloId],
  rules: () => [...compositeSloKeys.all, 'rules'],
  rule: sloIds => [...compositeSloKeys.rules(), sloIds],
  activeAlerts: () => [...compositeSloKeys.all, 'activeAlerts'],
  activeAlert: sloIds => [...compositeSloKeys.activeAlerts(), sloIds],
  historicalSummaries: () => [...compositeSloKeys.all, 'historicalSummary'],
  historicalSummary: sloIds => [...compositeSloKeys.historicalSummaries(), sloIds],
  globalDiagnosis: () => [...compositeSloKeys.all, 'globalDiagnosis']
};
exports.compositeSloKeys = compositeSloKeys;