"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchActiveAlerts = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchActiveAlerts = ({
  sloIds = []
}) => {
  return {
    isLoading: false,
    isSuccess: false,
    isError: false,
    data: sloIds.reduce((acc, sloId, index) => ({
      ...acc,
      ...(index % 2 === 0 && {
        [sloId]: {
          count: 2,
          ruleIds: ['rule-1', 'rule-2']
        }
      })
    }), {})
  };
};
exports.useFetchActiveAlerts = useFetchActiveAlerts;