"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HasDataContext = void 0;
exports.HasDataContextProvider = HasDataContextProvider;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _std = require("@kbn/std");
var _public = require("@kbn/observability-shared-plugin/public");
var _kibana_react = require("../../utils/kibana_react");
var _constants = require("../constants");
var _data_handler = require("./data_handler");
var _use_date_picker_context = require("../../hooks/use_date_picker_context");
var _get_observability_alerts = require("./get_observability_alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HasDataContext = /*#__PURE__*/(0, _react.createContext)({});
exports.HasDataContext = HasDataContext;
const apps = [_constants.APM_APP, _constants.UPTIME_APP, _constants.INFRA_LOGS_APP, _constants.INFRA_METRICS_APP, _constants.UX_APP, _constants.ALERT_APP];
function HasDataContextProvider({
  children
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const [forceUpdate, setForceUpdate] = (0, _react.useState)('');
  const {
    absoluteStart,
    absoluteEnd
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const [hasDataMap, setHasDataMap] = (0, _react.useState)({});
  const isExploratoryView = (0, _reactRouterDom.useRouteMatch)('/exploratory-view');
  (0, _react.useEffect)(() => {
    if (!isExploratoryView) (0, _std.asyncForEach)(apps, async app => {
      var _getDataHandler, _getDataHandler2, _getDataHandler3, _getDataHandler4, _getDataHandler5;
      try {
        const updateState = ({
          hasData,
          indices,
          serviceName
        }) => {
          setHasDataMap(prevState => ({
            ...prevState,
            [app]: {
              hasData,
              ...(serviceName ? {
                serviceName
              } : {}),
              ...(indices ? {
                indices
              } : {}),
              status: _public.FETCH_STATUS.SUCCESS
            }
          }));
        };
        switch (app) {
          case _constants.UX_APP:
            const params = {
              absoluteTime: {
                start: absoluteStart,
                end: absoluteEnd
              }
            };
            const resultUx = await ((_getDataHandler = (0, _data_handler.getDataHandler)(app)) === null || _getDataHandler === void 0 ? void 0 : _getDataHandler.hasData(params));
            updateState({
              hasData: resultUx === null || resultUx === void 0 ? void 0 : resultUx.hasData,
              indices: resultUx === null || resultUx === void 0 ? void 0 : resultUx.indices,
              serviceName: resultUx === null || resultUx === void 0 ? void 0 : resultUx.serviceName
            });
            break;
          case _constants.UPTIME_APP:
            const resultSy = await ((_getDataHandler2 = (0, _data_handler.getDataHandler)(app)) === null || _getDataHandler2 === void 0 ? void 0 : _getDataHandler2.hasData());
            updateState({
              hasData: resultSy === null || resultSy === void 0 ? void 0 : resultSy.hasData,
              indices: resultSy === null || resultSy === void 0 ? void 0 : resultSy.indices
            });
            break;
          case _constants.APM_APP:
            const resultApm = await ((_getDataHandler3 = (0, _data_handler.getDataHandler)(app)) === null || _getDataHandler3 === void 0 ? void 0 : _getDataHandler3.hasData());
            updateState({
              hasData: resultApm === null || resultApm === void 0 ? void 0 : resultApm.hasData,
              indices: resultApm === null || resultApm === void 0 ? void 0 : resultApm.indices
            });
            break;
          case _constants.INFRA_LOGS_APP:
            const resultInfraLogs = await ((_getDataHandler4 = (0, _data_handler.getDataHandler)(app)) === null || _getDataHandler4 === void 0 ? void 0 : _getDataHandler4.hasData());
            updateState({
              hasData: resultInfraLogs === null || resultInfraLogs === void 0 ? void 0 : resultInfraLogs.hasData,
              indices: resultInfraLogs === null || resultInfraLogs === void 0 ? void 0 : resultInfraLogs.indices
            });
            break;
          case _constants.INFRA_METRICS_APP:
            const resultInfraMetrics = await ((_getDataHandler5 = (0, _data_handler.getDataHandler)(app)) === null || _getDataHandler5 === void 0 ? void 0 : _getDataHandler5.hasData());
            updateState({
              hasData: resultInfraMetrics === null || resultInfraMetrics === void 0 ? void 0 : resultInfraMetrics.hasData,
              indices: resultInfraMetrics === null || resultInfraMetrics === void 0 ? void 0 : resultInfraMetrics.indices
            });
            break;
        }
      } catch (e) {
        setHasDataMap(prevState => ({
          ...prevState,
          [app]: {
            hasData: undefined,
            status: _public.FETCH_STATUS.FAILURE
          }
        }));
      }
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [isExploratoryView]);
  (0, _react.useEffect)(() => {
    async function fetchAlerts() {
      try {
        const alerts = await (0, _get_observability_alerts.getObservabilityAlerts)({
          http
        });
        setHasDataMap(prevState => ({
          ...prevState,
          [_constants.ALERT_APP]: {
            hasData: alerts.length > 0,
            status: _public.FETCH_STATUS.SUCCESS
          }
        }));
      } catch (e) {
        setHasDataMap(prevState => ({
          ...prevState,
          [_constants.ALERT_APP]: {
            hasData: undefined,
            status: _public.FETCH_STATUS.FAILURE
          }
        }));
      }
    }
    fetchAlerts();
  }, [forceUpdate, http]);
  const isAllRequestsComplete = apps.every(app => {
    var _hasDataMap$app;
    const appStatus = (_hasDataMap$app = hasDataMap[app]) === null || _hasDataMap$app === void 0 ? void 0 : _hasDataMap$app.status;
    return appStatus !== undefined && appStatus !== _public.FETCH_STATUS.LOADING;
  });
  const hasAnyData = Object.keys(hasDataMap).some(app => {
    var _hasDataMap$app2;
    const appHasData = (_hasDataMap$app2 = hasDataMap[app]) === null || _hasDataMap$app2 === void 0 ? void 0 : _hasDataMap$app2.hasData;
    return appHasData === true;
  });
  return /*#__PURE__*/_react.default.createElement(HasDataContext.Provider, {
    value: {
      hasDataMap,
      hasAnyData: (0, _lodash.isEmpty)(hasDataMap) ? undefined : hasAnyData,
      isAllRequestsComplete,
      forceUpdate,
      onRefreshTimeRange: () => {
        setForceUpdate((0, _lodash.uniqueId)());
      }
    },
    children: children
  });
}