"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricsExplorerOptionsContainerContext = exports.useMetricsExplorerOptions = exports.metricsExplorerTimestampsRT = exports.metricsExplorerTimeOptionsRT = exports.metricsExplorerChartOptionsRT = exports.metricExplorerOptionsRT = exports.MetricsExplorerYAxisMode = exports.MetricsExplorerOptionsContainer = exports.MetricsExplorerChartType = exports.DEFAULT_TIMERANGE = exports.DEFAULT_OPTIONS = exports.DEFAULT_METRICS_EXPLORER_VIEW_STATE = exports.DEFAULT_METRICS = exports.DEFAULT_CHART_OPTIONS = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _metrics_explorer = require("../../../../common/threshold_rule/metrics_explorer");
var _color_palette = require("../../../../common/threshold_rule/color_palette");
var _use_alert_prefill = require("../helpers/use_alert_prefill");
var _use_kibana_timefilter_time = require("./use_kibana_timefilter_time");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricsExplorerOptionsMetricRT = t.intersection([_metrics_explorer.metricsExplorerMetricRT, t.partial({
  rate: t.boolean,
  color: t.keyof(Object.fromEntries((0, _lodash.values)(_color_palette.Color).map(c => [c, null]))),
  label: t.string
})]);
let MetricsExplorerChartType;
exports.MetricsExplorerChartType = MetricsExplorerChartType;
(function (MetricsExplorerChartType) {
  MetricsExplorerChartType["line"] = "line";
  MetricsExplorerChartType["area"] = "area";
  MetricsExplorerChartType["bar"] = "bar";
})(MetricsExplorerChartType || (exports.MetricsExplorerChartType = MetricsExplorerChartType = {}));
let MetricsExplorerYAxisMode;
exports.MetricsExplorerYAxisMode = MetricsExplorerYAxisMode;
(function (MetricsExplorerYAxisMode) {
  MetricsExplorerYAxisMode["fromZero"] = "fromZero";
  MetricsExplorerYAxisMode["auto"] = "auto";
})(MetricsExplorerYAxisMode || (exports.MetricsExplorerYAxisMode = MetricsExplorerYAxisMode = {}));
const metricsExplorerChartOptionsRT = t.type({
  yAxisMode: t.keyof(Object.fromEntries((0, _lodash.values)(MetricsExplorerYAxisMode).map(v => [v, null]))),
  type: t.keyof(Object.fromEntries((0, _lodash.values)(MetricsExplorerChartType).map(v => [v, null]))),
  stack: t.boolean
});
exports.metricsExplorerChartOptionsRT = metricsExplorerChartOptionsRT;
const metricExplorerOptionsRequiredRT = t.type({
  aggregation: t.string,
  metrics: t.array(metricsExplorerOptionsMetricRT)
});
const metricExplorerOptionsOptionalRT = t.partial({
  limit: t.number,
  groupBy: t.union([t.string, t.array(t.string)]),
  filterQuery: t.string,
  source: t.string,
  forceInterval: t.boolean,
  dropLastBucket: t.boolean
});
const metricExplorerOptionsRT = t.intersection([metricExplorerOptionsRequiredRT, metricExplorerOptionsOptionalRT]);
exports.metricExplorerOptionsRT = metricExplorerOptionsRT;
const metricsExplorerTimestampsRT = t.type({
  fromTimestamp: t.number,
  toTimestamp: t.number,
  interval: t.string
});
exports.metricsExplorerTimestampsRT = metricsExplorerTimestampsRT;
const metricsExplorerTimeOptionsRT = t.type({
  from: t.string,
  to: t.string,
  interval: t.string
});
exports.metricsExplorerTimeOptionsRT = metricsExplorerTimeOptionsRT;
const DEFAULT_TIMERANGE = {
  from: 'now-1h',
  to: 'now',
  interval: '>=10s'
};
exports.DEFAULT_TIMERANGE = DEFAULT_TIMERANGE;
const DEFAULT_CHART_OPTIONS = {
  type: MetricsExplorerChartType.line,
  yAxisMode: MetricsExplorerYAxisMode.fromZero,
  stack: false
};
exports.DEFAULT_CHART_OPTIONS = DEFAULT_CHART_OPTIONS;
const DEFAULT_METRICS = [{
  aggregation: 'avg',
  field: 'system.cpu.total.norm.pct',
  color: _color_palette.Color.color0
}, {
  aggregation: 'avg',
  field: 'kubernetes.pod.cpu.usage.node.pct',
  color: _color_palette.Color.color1
}, {
  aggregation: 'avg',
  field: 'docker.cpu.total.pct',
  color: _color_palette.Color.color2
}];
exports.DEFAULT_METRICS = DEFAULT_METRICS;
const DEFAULT_OPTIONS = {
  aggregation: 'avg',
  metrics: DEFAULT_METRICS,
  source: 'default'
};
exports.DEFAULT_OPTIONS = DEFAULT_OPTIONS;
const DEFAULT_METRICS_EXPLORER_VIEW_STATE = {
  options: DEFAULT_OPTIONS,
  chartOptions: DEFAULT_CHART_OPTIONS,
  currentTimerange: DEFAULT_TIMERANGE
};
exports.DEFAULT_METRICS_EXPLORER_VIEW_STATE = DEFAULT_METRICS_EXPLORER_VIEW_STATE;
function parseJsonOrDefault(value, defaultValue) {
  if (!value) {
    return defaultValue;
  }
  try {
    return JSON.parse(value);
  } catch (e) {
    return defaultValue;
  }
}
function useStateWithLocalStorage(key, defaultState) {
  const storageState = localStorage.getItem(key);
  const [state, setState] = (0, _react.useState)(parseJsonOrDefault(storageState, defaultState));
  (0, _react.useEffect)(() => {
    localStorage.setItem(key, JSON.stringify(state));
  }, [key, state]);
  return [state, setState];
}
const getDefaultTimeRange = ({
  from,
  to
}) => {
  const fromTimestamp = _datemath.default.parse(from).valueOf();
  const toTimestamp = _datemath.default.parse(to, {
    roundUp: true
  }).valueOf();
  return {
    fromTimestamp,
    toTimestamp,
    interval: DEFAULT_TIMERANGE.interval
  };
};
const useMetricsExplorerOptions = () => {
  const TIME_DEFAULTS = {
    from: 'now-1h',
    to: 'now'
  };
  const [getTime] = (0, _use_kibana_timefilter_time.useKibanaTimefilterTime)(TIME_DEFAULTS);
  const {
    from,
    to
  } = getTime();
  const [options, setOptions] = useStateWithLocalStorage('MetricsExplorerOptions', DEFAULT_OPTIONS);
  const [timeRange, setTimeRange] = (0, _react.useState)({
    from,
    to,
    interval: DEFAULT_TIMERANGE.interval
  });
  const [timestamps, setTimestamps] = (0, _react.useState)(getDefaultTimeRange({
    from,
    to
  }));
  (0, _use_kibana_timefilter_time.useSyncKibanaTimeFilterTime)(TIME_DEFAULTS, {
    from: timeRange.from,
    to: timeRange.to
  });
  const [chartOptions, setChartOptions] = useStateWithLocalStorage('MetricsExplorerChartOptions', DEFAULT_CHART_OPTIONS);
  const [isAutoReloading, setAutoReloading] = (0, _react.useState)(false);
  const {
    metricThresholdPrefill
  } = (0, _use_alert_prefill.useAlertPrefillContext)();
  // For Jest compatibility; including metricThresholdPrefill as a dep in useEffect causes an
  // infinite loop in test environment
  const prefillContext = (0, _react.useMemo)(() => metricThresholdPrefill, [metricThresholdPrefill]);
  (0, _react.useEffect)(() => {
    if (prefillContext) {
      const {
        setPrefillOptions
      } = prefillContext;
      const {
        metrics,
        groupBy,
        filterQuery
      } = options;
      setPrefillOptions({
        metrics,
        groupBy,
        filterQuery
      });
    }
  }, [options, prefillContext]);
  return {
    defaultViewState: {
      options: DEFAULT_OPTIONS,
      chartOptions: DEFAULT_CHART_OPTIONS,
      currentTimerange: timeRange
    },
    options,
    chartOptions,
    setChartOptions,
    timeRange,
    isAutoReloading,
    setOptions,
    setTimeRange,
    startAutoReload: () => setAutoReloading(true),
    stopAutoReload: () => setAutoReloading(false),
    timestamps,
    setTimestamps
  };
};
exports.useMetricsExplorerOptions = useMetricsExplorerOptions;
const [MetricsExplorerOptionsContainer, useMetricsExplorerOptionsContainerContext] = (0, _constate.default)(useMetricsExplorerOptions);
exports.useMetricsExplorerOptionsContainerContext = useMetricsExplorerOptionsContainerContext;
exports.MetricsExplorerOptionsContainer = MetricsExplorerOptionsContainer;