"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricRowWithAgg = MetricRowWithAgg;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../common/threshold_rule/types");
var _metric_row_controls = require("./metric_row_controls");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MetricRowWithAgg({
  name,
  aggType = _types.Aggregators.AVERAGE,
  field,
  onDelete,
  disableDelete,
  fields,
  aggregationTypes,
  onChange,
  errors
}) {
  const handleDelete = (0, _react.useCallback)(() => {
    onDelete(name);
  }, [name, onDelete]);
  const fieldOptions = (0, _react.useMemo)(() => fields.reduce((acc, fieldValue) => {
    if (aggType && aggregationTypes[aggType].validNormalizedTypes.includes(fieldValue.normalizedType)) {
      acc.push({
        label: fieldValue.name
      });
    }
    return acc;
  }, []), [fields, aggregationTypes, aggType]);
  const aggOptions = (0, _react.useMemo)(() => Object.values(aggregationTypes).map(a => ({
    text: a.text,
    value: a.value
  })), [aggregationTypes]);
  const handleFieldChange = (0, _react.useCallback)(selectedOptions => {
    onChange({
      name,
      field: selectedOptions.length && selectedOptions[0].label || undefined,
      aggType
    });
  }, [name, aggType, onChange]);
  const handleAggChange = (0, _react.useCallback)(el => {
    onChange({
      name,
      field,
      aggType: el.target.value
    });
  }, [name, field, onChange]);
  const isAggInvalid = (0, _lodash.get)(errors, ['customMetrics', name, 'aggType']) != null;
  const isFieldInvalid = (0, _lodash.get)(errors, ['customMetrics', name, 'field']) != null || !field;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: 145
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.customEquationEditor.aggregationLabel', {
      defaultMessage: 'Aggregation {name}',
      values: {
        name
      }
    }),
    isInvalid: isAggInvalid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "thresholdRuleMetricRowWithAggSelect",
    compressed: true,
    options: aggOptions,
    value: aggType,
    isInvalid: isAggInvalid,
    onChange: handleAggChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.customEquationEditor.fieldLabel', {
      defaultMessage: 'Field {name}',
      values: {
        name
      }
    }),
    isInvalid: isFieldInvalid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    isInvalid: isFieldInvalid,
    singleSelection: {
      asPlainText: true
    },
    options: fieldOptions,
    selectedOptions: field ? [{
      label: field
    }] : [],
    onChange: handleFieldChange
  }))), /*#__PURE__*/_react.default.createElement(_metric_row_controls.MetricRowControls, {
    onDelete: handleDelete,
    disableDelete: disableDelete
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }));
}