"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeedbackButton = FeedbackButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_FEEDBACK_LINK = 'https://ela.st/slo-feedback';
function FeedbackButton({
  disabled
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloFeedbackButton",
    isDisabled: disabled,
    href: SLO_FEEDBACK_LINK,
    target: "_blank",
    color: "warning",
    iconType: "editorComment"
  }, _i18n.i18n.translate('xpack.observability.slo.feedbackButtonLabel', {
    defaultMessage: 'Tell us what you think!'
  }));
}