"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Windows = Windows;
exports.createNewWindow = exports.calculateMaxBurnRateThreshold = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _uuid = require("uuid");
var _i18nReact = require("@kbn/i18n-react");
var _burn_rate = require("./burn_rate");
var _long_window_duration = require("./long_window_duration");
var _duration = require("../../utils/slo/duration");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTION_GROUP_OPTIONS = [{
  value: _constants.ALERT_ACTION.id,
  text: _constants.ALERT_ACTION.name
}, {
  value: _constants.HIGH_PRIORITY_ACTION.id,
  text: _constants.HIGH_PRIORITY_ACTION.name
}, {
  value: _constants.MEDIUM_PRIORITY_ACTION.id,
  text: _constants.MEDIUM_PRIORITY_ACTION.name
}, {
  value: _constants.LOW_PRIORITY_ACTION.id,
  text: _constants.LOW_PRIORITY_ACTION.name
}];
const calculateMaxBurnRateThreshold = (longWindow, slo) => {
  return slo ? Math.floor((0, _duration.toMinutes)((0, _duration.toDuration)(slo.timeWindow.duration)) / (0, _duration.toMinutes)(longWindow)) : Infinity;
};
exports.calculateMaxBurnRateThreshold = calculateMaxBurnRateThreshold;
function Window({
  slo,
  id,
  burnRateThreshold,
  maxBurnRateThreshold,
  longWindow,
  shortWindow,
  actionGroup,
  onChange,
  onDelete,
  errors,
  disableDelete
}) {
  const onLongWindowDurationChange = duration => {
    const longWindowDurationInMinutes = (0, _duration.toMinutes)(duration);
    const shortWindowDurationValue = Math.floor(longWindowDurationInMinutes / 12);
    onChange({
      id,
      burnRateThreshold,
      maxBurnRateThreshold,
      longWindow: duration,
      shortWindow: {
        value: shortWindowDurationValue,
        unit: 'm'
      },
      actionGroup
    });
  };
  const onBurnRateChange = value => {
    onChange({
      id,
      burnRateThreshold: value,
      maxBurnRateThreshold: calculateMaxBurnRateThreshold(longWindow, slo),
      longWindow,
      shortWindow,
      actionGroup
    });
  };
  const onActionGroupChange = event => {
    onChange({
      id,
      burnRateThreshold,
      maxBurnRateThreshold,
      longWindow,
      shortWindow,
      actionGroup: event.currentTarget.value
    });
  };
  const computeErrorBudgetExhaustionInHours = () => {
    if (slo && (longWindow === null || longWindow === void 0 ? void 0 : longWindow.value) > 0 && burnRateThreshold >= 1) {
      return (0, _numeral.default)(longWindow.value / (burnRateThreshold * (0, _duration.toMinutes)(longWindow) / (0, _duration.toMinutes)((0, _duration.toDuration)(slo.timeWindow.duration)))).format('0a');
    }
    return 'N/A';
  };
  const allErrors = [...errors.longWindow, ...errors.burnRateThreshold];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_long_window_duration.LongWindowDuration, {
    initialDuration: longWindow,
    shortWindowDuration: shortWindow,
    onChange: onLongWindowDurationChange,
    errors: errors.longWindow
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_burn_rate.BurnRate, {
    initialBurnRate: burnRateThreshold,
    maxBurnRate: maxBurnRateThreshold,
    onChange: onBurnRateChange,
    errors: errors.burnRateThreshold,
    helpText: getErrorBudgetExhaustionText(computeErrorBudgetExhaustionInHours())
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.slo.rules.actionGroupSelectorLabel', {
      defaultMessage: 'Action Group'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "sloBurnRateActionGroupSelctor",
    options: ACTION_GROUP_OPTIONS,
    value: actionGroup,
    onChange: onActionGroupChange,
    "aria-label": _i18n.i18n.translate('xpack.observability.slo.rules.actionGroupSelectorLabel', {
      defaultMessage: 'Action Group'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "sloBurnRateRuleDeleteWindowButton",
    iconType: "trash",
    color: "danger",
    style: {
      marginBottom: '-1em'
    },
    onClick: () => onDelete(id),
    disabled: disableDelete,
    title: _i18n.i18n.translate('xpack.observability.slo.rules.deleteWindowLabel', {
      defaultMessage: 'Delete window'
    }),
    "aria-label": _i18n.i18n.translate('xpack.observability.slo.rules.deleteWindowLabel', {
      defaultMessage: 'Delete window'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), allErrors.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "xs"
  }, allErrors.map(msg => /*#__PURE__*/_react.default.createElement("p", {
    key: msg
  }, msg))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, getErrorBudgetExhaustionText(computeErrorBudgetExhaustionInHours()))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}
const getErrorBudgetExhaustionText = formattedHours => _i18n.i18n.translate('xpack.observability.slo.rules.errorBudgetExhaustion.text', {
  defaultMessage: '{formatedHours} hours until error budget exhaustion.',
  values: {
    formatedHours: formattedHours
  }
});
const createNewWindow = (slo, partialWindow = {}) => {
  const longWindow = partialWindow.longWindow || {
    value: 1,
    unit: 'h'
  };
  return {
    id: (0, _uuid.v4)(),
    burnRateThreshold: 1,
    maxBurnRateThreshold: calculateMaxBurnRateThreshold(longWindow, slo),
    longWindow,
    shortWindow: {
      value: 5,
      unit: 'm'
    },
    actionGroup: _constants.ALERT_ACTION.id,
    ...partialWindow
  };
};
exports.createNewWindow = createNewWindow;
function Windows({
  slo,
  windows,
  errors,
  onChange,
  totalNumberOfWindows
}) {
  const handleWindowChange = windowDef => {
    onChange(windows.map(def => windowDef.id === def.id ? windowDef : def));
  };
  const handleWindowDelete = id => {
    onChange(windows.length > 1 ? windows.filter(windowDef => windowDef.id !== id) : windows);
  };
  const handleAddWindow = () => {
    onChange([...windows, createNewWindow()]);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, windows.map((windowDef, index) => {
    const windowErrors = errors[index] || {
      longWindow: new Array(),
      burnRateThreshold: new Array()
    };
    return /*#__PURE__*/_react.default.createElement(Window, (0, _extends2.default)({}, windowDef, {
      key: windowDef.id,
      slo: slo,
      errors: windowErrors,
      onChange: handleWindowChange,
      onDelete: handleWindowDelete,
      disableDelete: windows.length === 1
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "sloBurnRateRuleAddWindowButton",
    color: 'primary',
    size: "xs",
    iconType: 'plusInCircleFilled',
    onClick: handleAddWindow,
    isDisabled: windows.length === (totalNumberOfWindows || 4),
    "aria-label": _i18n.i18n.translate('xpack.observability.slo.rules.addWindowAriaLabel', {
      defaultMessage: 'Add window'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.slo.rules.addWIndowLabel",
    defaultMessage: "Add window"
  })));
}