"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateYml = void 0;
var _jsYaml = require("js-yaml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateYml = ({
  datasetName = '',
  serviceName,
  namespace = '',
  customConfigurations,
  logFilePaths = [],
  apiKey,
  esHost,
  logfileId
}) => {
  const customConfigYaml = (0, _jsYaml.load)(customConfigurations !== null && customConfigurations !== void 0 ? customConfigurations : '');
  const processors = [{
    add_fields: {
      target: 'service',
      fields: {
        name: serviceName
      }
    }
  }];
  return (0, _jsYaml.dump)({
    ...{
      outputs: {
        default: {
          type: 'elasticsearch',
          hosts: esHost,
          api_key: apiKey
        }
      },
      inputs: [{
        id: logfileId,
        type: 'logfile',
        data_stream: {
          namespace
        },
        streams: [{
          id: `logs-onboarding-${datasetName}`,
          data_stream: {
            dataset: datasetName
          },
          paths: logFilePaths,
          ...(serviceName ? {
            processors
          } : {})
        }]
      }]
    },
    ...customConfigYaml
  });
};
exports.generateYml = generateYml;