"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createShipperApiKey = createShipperApiKey;
var _monitoring_config = require("./monitoring_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createShipperApiKey(esClient, name) {
  // Based on https://www.elastic.co/guide/en/fleet/master/grant-access-to-elasticsearch.html#create-api-key-standalone-agent
  return esClient.security.createApiKey({
    body: {
      name: `standalone_agent_custom_logs_${name}`,
      metadata: {
        application: 'logs'
      },
      role_descriptors: {
        standalone_agent: {
          cluster: _monitoring_config.cluster,
          indices: _monitoring_config.indices
        }
      }
    }
  });
}