"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@kbn/config-schema");
var _plugin = require("./plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = _configSchema.schema.object({
  ui: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  })
});
// plugin config
const config = {
  exposeToBrowser: {
    ui: true
  },
  schema: configSchema
};
exports.config = config;
function plugin(initializerContext) {
  return new _plugin.ObservabilityOnboardingPlugin(initializerContext);
}