"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepPanel = StepPanel;
exports.StepPanelContent = StepPanelContent;
exports.StepPanelFooter = StepPanelFooter;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StepPanel(props) {
  var _props$panelProps;
  const {
    title,
    children,
    panelFooter
  } = props;
  const panelProps = (_props$panelProps = props.panelProps) !== null && _props$panelProps !== void 0 ? _props$panelProps : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, panelProps, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, title))), children)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), panelFooter);
}
function StepPanelContent(props) {
  const {
    children
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children);
}
function StepPanelFooter(props) {
  const {
    items = [],
    children
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginBottom: euiTheme.size.l
    }
  }, children, items && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, items.map((itemReactNode, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    grow: false
  }, itemReactNode))));
}