"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWizard = exports.Step = exports.Provider = void 0;
var _configure_logs = require("./configure_logs");
var _select_logs = require("./select_logs");
var _install_elastic_agent = require("./install_elastic_agent");
var _create_wizard_context = require("../../../../context/create_wizard_context");
var _inspect = require("./inspect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  datasetName: '',
  serviceName: '',
  logFilePaths: [''],
  namespace: 'default',
  customConfigurations: '',
  elasticAgentPlatform: 'linux-tar',
  autoDownloadConfig: false,
  apiKeyEncoded: '',
  onboardingId: ''
};
const {
  Provider,
  Step,
  useWizard
} = (0, _create_wizard_context.createWizardContext)({
  initialState,
  initialStep: 'selectLogs',
  steps: {
    selectLogs: _select_logs.SelectLogs,
    configureLogs: _configure_logs.ConfigureLogs,
    installElasticAgent: _install_elastic_agent.InstallElasticAgent,
    inspect: _inspect.Inspect
  }
});
exports.useWizard = useWizard;
exports.Step = Step;
exports.Provider = Provider;