"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyBanner = ApiKeyBanner;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ApiKeyBanner({
  hasPrivileges = true,
  status,
  payload,
  error
}) {
  var _payload$apiKeyEncode, _error$body;
  const loadingCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.observability_onboarding.apiKeyBanner.loading', {
      defaultMessage: 'Creating API Key'
    }))),
    color: "primary"
  });
  const apiKeySuccessCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.apiKeyBanner.created', {
      defaultMessage: 'API Key created.'
    }),
    color: "success",
    iconType: "check"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.apiKeyBanner.created.description', {
    defaultMessage: 'Remember to store this information in a safe place. It won’t be displayed anymore after you continue.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "apmAgentKeyCallOutFieldText",
    readOnly: true,
    value: payload === null || payload === void 0 ? void 0 : payload.apiKeyEncoded,
    "aria-label": _i18n.i18n.translate('xpack.observability_onboarding.apiKeyBanner.field.label', {
      defaultMessage: 'Api Key'
    }),
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: (_payload$apiKeyEncode = payload === null || payload === void 0 ? void 0 : payload.apiKeyEncoded) !== null && _payload$apiKeyEncode !== void 0 ? _payload$apiKeyEncode : ''
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "copyClipboard",
      onClick: copy,
      color: "success",
      css: {
        '> svg.euiIcon': {
          borderRadius: '0 !important'
        }
      },
      "aria-label": _i18n.i18n.translate('xpack.observability_onboarding.apiKeyBanner.field.copyButton', {
        defaultMessage: 'Copy to clipboard'
      })
    }))
  }));
  const apiKeyFailureCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.apiKeyBanner.failed', {
      defaultMessage: 'Failed to create API key.'
    }),
    color: "danger",
    iconType: "error"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.apiKeyBanner.failed.description', {
    defaultMessage: 'Something went wrong: {message}',
    values: {
      message: error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message
    }
  })));
  const noPermissionsCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.apiKeyBanner.noPermissions', {
      defaultMessage: 'User does not have permissions to create API key.'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.apiKeyBanner.noPermissions.description', {
    defaultMessage: 'Required cluster privileges are {requiredClusterPrivileges} and required index privileges are {requiredIndexPrivileges} for indices {indices}, please add all required privileges to the role of the authenticated user.',
    values: {
      requiredClusterPrivileges: "['monitor', 'manage_own_api_key']",
      requiredIndexPrivileges: "['auto_configure', 'create_doc']",
      indices: "['logs-*-*', 'metrics-*-*']"
    }
  })));
  if (!hasPrivileges) {
    return noPermissionsCallout;
  }
  if (status === _public.FETCH_STATUS.SUCCESS) {
    return apiKeySuccessCallout;
  }
  if (status === _public.FETCH_STATUS.FAILURE) {
    return apiKeyFailureCallout;
  }
  return loadingCallout;
}