"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenu = TopNavMenu;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _public = require("@kbn/kibana-react-plugin/public");
var _top_nav_menu_item = require("./top_nav_menu_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Top Nav Menu is a convenience wrapper component for:
 * - Top navigation menu - configured by an array of `TopNavMenuData` objects
 * - Search Bar - which includes Filter Bar \ Query Input \ Timepicker.
 *
 * See SearchBar documentation to learn more about its properties.
 *
 **/

function TopNavMenu(props) {
  const {
    config,
    badges,
    showSearchBar,
    ...searchBarProps
  } = props;
  if ((!config || config.length === 0) && (!showSearchBar || !props.unifiedSearch)) {
    return null;
  }
  function createBadge({
    badgeText,
    toolTipProps,
    ...badgeProps
  }, i) {
    const Badge = ({
      key,
      ...rest
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      key: key,
      tabIndex: 0
    }, rest, badgeProps), badgeText);
    const key = `nav-menu-badge-${i}`;
    return toolTipProps ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, (0, _extends2.default)({
      key: key
    }, toolTipProps), /*#__PURE__*/_react.default.createElement(Badge, null)) : /*#__PURE__*/_react.default.createElement(Badge, {
      key: key
    });
  }
  function renderBadges() {
    if (!badges || badges.length === 0) return null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
      className: 'kbnTopNavMenu__badgeGroup'
    }, badges.map(createBadge));
  }
  function renderItems() {
    if (!config || config.length === 0) return null;
    return config.map((menuItem, i) => {
      return /*#__PURE__*/_react.default.createElement(_top_nav_menu_item.TopNavMenuItem, (0, _extends2.default)({
        key: `nav-menu-${i}`
      }, menuItem));
    });
  }
  function renderMenu(className) {
    if (!config || config.length === 0) return null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
      "data-test-subj": "top-nav",
      gutterSize: "xs",
      className: className
    }, renderItems());
  }
  function renderSearchBar() {
    // Validate presense of all required fields
    if (!showSearchBar || !props.unifiedSearch) return null;
    const {
      AggregateQuerySearchBar
    } = props.unifiedSearch.ui;
    return /*#__PURE__*/_react.default.createElement(AggregateQuerySearchBar, searchBarProps);
  }
  function renderLayout() {
    const {
      setMenuMountPoint,
      visible
    } = props;
    const menuClassName = (0, _classnames.default)('kbnTopNavMenu', props.className);
    const wrapperClassName = (0, _classnames.default)('kbnTopNavMenu__wrapper', {
      'kbnTopNavMenu__wrapper--hidden': visible === false
    });
    if (setMenuMountPoint) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.MountPointPortal, {
        setMountPoint: setMenuMountPoint
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: `${wrapperClassName} kbnTopNavMenu__badgeWrapper`
      }, renderBadges(), renderMenu(menuClassName))), renderSearchBar());
    } else {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        className: wrapperClassName
      }, renderMenu(menuClassName)), renderSearchBar());
    }
  }
  return renderLayout();
}
TopNavMenu.defaultProps = {
  showSearchBar: false,
  showQueryInput: true,
  showDatePicker: true,
  showFilterBar: true,
  screenTitle: ''
};