"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _constants = require("../common/constants");
var _ccr_read_exceptions_alert = require("./alerts/ccr_read_exceptions_alert");
var _cpu_usage_alert = require("./alerts/cpu_usage_alert");
var _disk_usage_alert = require("./alerts/disk_usage_alert");
var _large_shard_size_alert = require("./alerts/large_shard_size_alert");
var _legacy_alert = require("./alerts/legacy_alert");
var _memory_usage_alert = require("./alerts/memory_usage_alert");
var _missing_monitoring_data_alert = require("./alerts/missing_monitoring_data_alert");
var _thread_pool_rejections_alert = require("./alerts/thread_pool_rejections_alert");
var _external_config = require("./external_config");
var _legacy_shims = require("./legacy_shims");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class MonitoringPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  setup(core, plugins) {
    const {
      home
    } = plugins;
    const id = 'monitoring';
    const icon = 'monitoringApp';
    const title = _i18n.i18n.translate('xpack.monitoring.stackMonitoringTitle', {
      defaultMessage: 'Stack Monitoring'
    });
    const monitoring = this.initializerContext.config.get();
    if (!monitoring.ui.enabled) {
      return false;
    }
    if (home) {
      home.featureCatalogue.register({
        id,
        title: _i18n.i18n.translate('xpack.monitoring.featureCatalogueTitle', {
          defaultMessage: 'Monitor the stack'
        }),
        icon,
        path: '/app/monitoring',
        showOnHomePage: true,
        category: 'admin',
        description: _i18n.i18n.translate('xpack.monitoring.featureCatalogueDescription', {
          defaultMessage: 'Track the real-time health and performance of your deployment.'
        }),
        order: 610
      });
    }
    this.registerAlerts(plugins, monitoring);
    const app = {
      id,
      title,
      order: 9030,
      euiIconType: icon,
      category: _public.DEFAULT_APP_CATEGORIES.management,
      mount: async params => {
        var _plugins$cloud;
        const [coreStart, pluginsStart] = await core.getStartServices();
        const externalConfig = this.getExternalConfig();
        const deps = {
          navigation: pluginsStart.navigation,
          element: params.element,
          core: coreStart,
          data: pluginsStart.data,
          isCloud: Boolean((_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.isCloudEnabled),
          pluginInitializerContext: this.initializerContext,
          externalConfig,
          triggersActionsUi: pluginsStart.triggersActionsUi,
          usageCollection: plugins.usageCollection,
          appMountParameters: params,
          dataViews: pluginsStart.dataViews,
          infra: pluginsStart.infra
        };
        _legacy_shims.Legacy.init({
          core: deps.core,
          element: deps.element,
          data: deps.data,
          navigation: deps.navigation,
          isCloud: deps.isCloud,
          pluginInitializerContext: deps.pluginInitializerContext,
          externalConfig: deps.externalConfig,
          triggersActionsUi: deps.triggersActionsUi,
          usageCollection: deps.usageCollection,
          appMountParameters: deps.appMountParameters,
          dataViews: deps.dataViews,
          infra: deps.infra
        });
        const config = Object.fromEntries(externalConfig);
        (0, _external_config.setConfig)(config);
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        return renderApp(coreStart, pluginsStart, params, config);
      }
    };
    core.application.register(app);
  }
  start(core, plugins) {}
  stop() {}
  getExternalConfig() {
    const monitoring = this.initializerContext.config.get();
    return [['minIntervalSeconds', monitoring.ui.min_interval_seconds], ['showLicenseExpiration', monitoring.ui.show_license_expiration], ['showCgroupMetricsElasticsearch', monitoring.ui.container.elasticsearch.enabled], ['showCgroupMetricsLogstash', monitoring.ui.container.logstash.enabled], ['staleStatusThresholdSeconds', monitoring.ui.kibana.reporting.stale_status_threshold_seconds], ['isCcsEnabled', monitoring.ui.ccs.enabled]];
  }
  registerAlerts(plugins, config) {
    const {
      triggersActionsUi: {
        ruleTypeRegistry
      }
    } = plugins;
    ruleTypeRegistry.register((0, _cpu_usage_alert.createCpuUsageAlertType)(config));
    ruleTypeRegistry.register((0, _disk_usage_alert.createDiskUsageAlertType)(config));
    ruleTypeRegistry.register((0, _memory_usage_alert.createMemoryUsageAlertType)(config));
    ruleTypeRegistry.register((0, _missing_monitoring_data_alert.createMissingMonitoringDataAlertType)());
    ruleTypeRegistry.register((0, _thread_pool_rejections_alert.createThreadPoolRejectionsAlertType)(_constants.RULE_THREAD_POOL_SEARCH_REJECTIONS, _constants.RULE_DETAILS[_constants.RULE_THREAD_POOL_SEARCH_REJECTIONS], config));
    ruleTypeRegistry.register((0, _thread_pool_rejections_alert.createThreadPoolRejectionsAlertType)(_constants.RULE_THREAD_POOL_WRITE_REJECTIONS, _constants.RULE_DETAILS[_constants.RULE_THREAD_POOL_WRITE_REJECTIONS], config));
    ruleTypeRegistry.register((0, _ccr_read_exceptions_alert.createCCRReadExceptionsAlertType)(config));
    ruleTypeRegistry.register((0, _large_shard_size_alert.createLargeShardSizeAlertType)(config));
    const legacyAlertTypes = (0, _legacy_alert.createLegacyAlertTypes)(config);
    for (const legacyAlertType of legacyAlertTypes) {
      ruleTypeRegistry.register(legacyAlertType);
    }
  }
}
exports.MonitoringPlugin = MonitoringPlugin;