"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CheckerErrors = CheckerErrors;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorList = ({
  errors
}) => {
  const errorsMap = {};
  return errors.filter(err => {
    const {
      statusCode,
      error,
      message
    } = err;
    const key = `${statusCode}${error}${message}`;
    if (!errorsMap[key]) {
      errorsMap[key] = true;
      return true;
    }
  }).map((error, errorIndex) => {
    const {
      message,
      statusCode,
      error: friendlyName
    } = error;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `checker-error-${errorIndex}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, statusCode, " ", friendlyName), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, message));
  });
};
function CheckerErrors(props) {
  if (props.errors === undefined || props.errors.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Errors found",
    color: "danger",
    className: "eui-textLeft"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.checkerErrors.checkEsSettingsErrorMessage",
    defaultMessage: "There were some errors encountered in trying to check Elasticsearch settings. You need administrator rights to check the settings and, if needed, to enable the monitoring collection setting."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(ErrorList, props))));
}
CheckerErrors.propTypes = {
  errors: _propTypes.default.array
};