"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogstashInstructionsForEnablingMetricbeat = getLogstashInstructionsForEnablingMetricbeat;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _monospace = require("../components/monospace");
var _i18nReact = require("@kbn/i18n-react");
var _legacy_shims = require("../../../../legacy_shims");
var _common_instructions = require("../common_instructions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLogstashInstructionsForEnablingMetricbeat(product, _meta, {
  esMonitoringUrl
}) {
  const logstashUrl = _legacy_shims.Legacy.shims.docLinks.links.monitoring.monitorLogstash;
  const metricbeatInstallUrl = _legacy_shims.Legacy.shims.docLinks.links.metricbeat.install;
  const metricbeatStartUrl = _legacy_shims.Legacy.shims.docLinks.links.metricbeat.start;
  const securitySetup = (0, _common_instructions.getSecurityStep)(logstashUrl);
  const installMetricbeatStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.logstashInstructions.installMetricbeatTitle', {
      defaultMessage: 'Install Metricbeat on the same server as Logstash'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: metricbeatInstallUrl,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.logstashInstructions.installMetricbeatLinkText",
      defaultMessage: "Follow the instructions here."
    }))))
  };
  const enableMetricbeatModuleStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.logstashInstructions.enableMetricbeatModuleTitle', {
      defaultMessage: 'Enable and configure the Logstash x-pack module in Metricbeat'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      language: "bash"
    }, "metricbeat modules enable logstash-xpack"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.logstashInstructions.enableMetricbeatModuleDescription",
      defaultMessage: "By default the module will collect Logstash monitoring metrics from http://localhost:9600. If the local Logstash instance has a different address, you must specify it via the {hosts} setting in the {file} file.",
      values: {
        hosts: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, null, "hosts"),
        file: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, null, "modules.d/logstash-xpack.yml")
      }
    }))), securitySetup)
  };
  const configureMetricbeatStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.logstashInstructions.configureMetricbeatTitle', {
      defaultMessage: 'Configure Metricbeat to send to the monitoring cluster'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.logstashInstructions.configureMetricbeatDescription",
      defaultMessage: "Make these changes in your {file}.",
      values: {
        file: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, null, "metricbeat.yml")
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true
    }, `output.elasticsearch:
  hosts: [${esMonitoringUrl}] ## Monitoring cluster

  # Optional protocol and basic auth credentials.
  #protocol: "https"
  #username: "elastic"
  #password: "changeme"
`), securitySetup)
  };
  const startMetricbeatStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.logstashInstructions.startMetricbeatTitle', {
      defaultMessage: 'Start Metricbeat'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: metricbeatStartUrl,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.logstashInstructions.startMetricbeatLinkText",
      defaultMessage: "Follow the instructions here."
    }))))
  };
  const migrationStatusStep = (0, _common_instructions.getMigrationStatusStep)(product);
  return [installMetricbeatStep, enableMetricbeatModuleStep, configureMetricbeatStep, startMetricbeatStep, migrationStatusStep];
}