"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDetailStatus = IndexDetailStatus;
var _react = _interopRequireWildcard(require("react"));
var _summary_status = require("../../summary_status");
var _status_icon = require("../status_icon");
var _format_number = require("../../../lib/format_number");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _status = require("../../../alerts/status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IndexDetailStatus({
  stats,
  alerts = {}
}) {
  const {
    dataSize,
    documents: documentCount,
    totalShards,
    unassignedShards,
    status
  } = stats;
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.alerts', {
      defaultMessage: 'Alerts'
    }),
    value: /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
      alerts: alerts,
      showOnlyCount: true
    })
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.totalTitle', {
      defaultMessage: 'Total'
    }),
    value: (0, _format_number.formatMetric)(dataSize.total, '0.0 b'),
    'data-test-subj': 'dataSize'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.primariesTitle', {
      defaultMessage: 'Primaries'
    }),
    value: (0, _format_number.formatMetric)(dataSize.primaries, '0.0 b'),
    'data-test-subj': 'dataSizePrimaries'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.documentsTitle', {
      defaultMessage: 'Documents'
    }),
    value: (0, _format_number.formatMetric)(documentCount, '0.[0]a'),
    'data-test-subj': 'documentCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.totalShardsTitle', {
      defaultMessage: 'Total shards'
    }),
    value: (0, _format_number.formatMetric)(totalShards, 'int_commas'),
    'data-test-subj': 'totalShards'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indexDetailStatus.unassignedShardsTitle', {
      defaultMessage: 'Unassigned shards'
    }),
    value: (0, _format_number.formatMetric)(unassignedShards, 'int_commas'),
    'data-test-subj': 'unassignedShards'
  }];
  const IconComponent = ({
    status
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.indexDetailStatus.iconStatusLabel",
    defaultMessage: "Health: {elasticsearchStatusIcon}",
    values: {
      elasticsearchStatusIcon: /*#__PURE__*/_react.default.createElement(_status_icon.ElasticsearchStatusIcon, {
        status: status
      })
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    status: status,
    IconComponent: IconComponent,
    "data-test-subj": "elasticsearchIndexDetailStatus"
  });
}