"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnits = getUnits;
var _lodash = require("lodash");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getUnits(series) {
  let units = (0, _lodash.get)(series, '[0].metric.units');

  // For Bytes, find the largest unit from any data set's _last_ item
  if (units === 'B') {
    let maxLastBytes = 0;
    (0, _lodash.forEach)(series, s => {
      const lastDataPoint = (0, _lodash.last)(s.data) || [null, 0];
      maxLastBytes = Math.max(maxLastBytes, lastDataPoint[1]); // lastDataPoint[1] is the "y" value
    });

    units = (0, _numeral.default)(maxLastBytes).byteUnits();
  }
  return units;
}