"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BeatsOverview = BeatsOverview;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _latest_active = require("./latest_active");
var _latest_versions = require("./latest_versions");
var _latest_types = require("./latest_types");
var _ = require("..");
var _chart = require("../../chart");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function renderLatestActive(latestActive, latestTypes, latestVersions) {
  if (latestTypes && latestTypes.length > 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.beats.overview.activeBeatsInLastDayTitle",
      defaultMessage: "Active Beats in last day"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_latest_active.LatestActive, {
      latestActive: latestActive
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.beats.overview.top5BeatTypesInLastDayTitle",
      defaultMessage: "Top 5 Beat Types in last day"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_latest_types.LatestTypes, {
      latestTypes: latestTypes
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.beats.overview.top5VersionsInLastDayTitle",
      defaultMessage: "Top 5 Versions in last day"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_latest_versions.LatestVersions, {
      latestVersions: latestVersions
    })));
  }
  const calloutMsg = _i18n.i18n.translate('xpack.monitoring.beats.overview.noActivityDescription', {
    defaultMessage: 'Hi there! This area is where your latest Beats activity would show up, ' + `but you don't seem to have any activity within the last day.`
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: calloutMsg,
    iconType: "gear",
    "data-test-subj": "noRecentActivityMessage"
  });
}
function BeatsOverview({
  latestActive,
  latestTypes,
  latestVersions,
  stats,
  metrics,
  alerts,
  ...props
}) {
  const seriesToShow = [metrics.beat_event_rates, metrics.beat_fail_rates, metrics.beat_throughput_rates, metrics.beat_output_errors];
  const charts = seriesToShow.map((data, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: '45%'
    },
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, (0, _extends2.default)({
    series: data
  }, props)))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.beats.overview.heading",
    defaultMessage: "Beats Overview"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_.Stats, {
    stats: stats,
    alerts: alerts
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, renderLatestActive(latestActive, latestTypes, latestVersions)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, charts))));
}