"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Status = Status;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _summary_status = require("../../summary_status");
var _status_icon = require("../status_icon");
var _format_number = require("../../../lib/format_number");
var _common = require("../../../../common");
var _constants = require("../../../../common/constants");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Status({
  alerts,
  stats
}) {
  const {
    apms: {
      total
    },
    totalEvents,
    timeOfLastEvent
  } = stats;
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.apm.instances.status.serversLabel', {
      defaultMessage: 'Servers'
    }),
    value: total,
    'data-test-subj': 'total'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.apm.instances.status.totalEventsLabel', {
      defaultMessage: 'Total Events'
    }),
    value: (0, _format_number.formatMetric)(totalEvents, '0.[0]a'),
    'data-test-subj': 'totalEvents'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.apm.instances.status.lastEventLabel', {
      defaultMessage: 'Last Event'
    }),
    value: _i18n.i18n.translate('xpack.monitoring.apm.instances.status.lastEventDescription', {
      defaultMessage: '{timeOfLastEvent} ago',
      values: {
        timeOfLastEvent: (0, _common.formatTimestampToDuration)(+(0, _moment.default)(timeOfLastEvent), _constants.CALCULATE_DURATION_SINCE)
      }
    }),
    'data-test-subj': 'timeOfLastEvent'
  }];
  const IconComponent = ({
    status
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.apm.instances.statusDescription",
    defaultMessage: "Status: {apmStatusIcon}",
    values: {
      apmStatusIcon: /*#__PURE__*/_react.default.createElement(_status_icon.ApmStatusIcon, {
        status: status
      })
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    alerts: alerts,
    IconComponent: IconComponent,
    "data-test-subj": "apmDetailStatus"
  });
}