"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLCompletionAdapter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _dymanic_item = require("../autocomplete/dymanic_item");
var _dynamic_commands = require("../autocomplete/autocomplete_definitions/dynamic_commands");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const emptyCompletionList = {
  incomplete: false,
  suggestions: []
};
class ESQLCompletionAdapter {
  constructor(worker, callbacks) {
    (0, _defineProperty2.default)(this, "triggerCharacters", ['(', ' ', '']);
    this.worker = worker;
    this.callbacks = callbacks;
  }
  async injectDynamicAutocompleteItems(suggestions, ctx) {
    let result = [];
    for (const suggestion of suggestions) {
      if ((0, _dymanic_item.isDynamicAutocompleteItem)(suggestion)) {
        let dynamicItems = [];
        if (suggestion === _dymanic_item.DynamicAutocompleteItem.SourceIdentifier) {
          var _await$this$callbacks, _this$callbacks, _this$callbacks$getSo, _this$callbacks2;
          dynamicItems = (0, _dynamic_commands.buildSourcesDefinitions)((_await$this$callbacks = await ((_this$callbacks = this.callbacks) === null || _this$callbacks === void 0 ? void 0 : (_this$callbacks$getSo = (_this$callbacks2 = _this$callbacks).getSourceIdentifiers) === null || _this$callbacks$getSo === void 0 ? void 0 : _this$callbacks$getSo.call(_this$callbacks2, ctx))) !== null && _await$this$callbacks !== void 0 ? _await$this$callbacks : []);
        }
        if (suggestion === _dymanic_item.DynamicAutocompleteItem.FieldIdentifier) {
          var _await$this$callbacks2, _this$callbacks3, _this$callbacks3$getF, _this$callbacks4;
          dynamicItems = (0, _dynamic_commands.buildFieldsDefinitions)((_await$this$callbacks2 = await ((_this$callbacks3 = this.callbacks) === null || _this$callbacks3 === void 0 ? void 0 : (_this$callbacks3$getF = (_this$callbacks4 = _this$callbacks3).getFieldsIdentifiers) === null || _this$callbacks3$getF === void 0 ? void 0 : _this$callbacks3$getF.call(_this$callbacks4, ctx))) !== null && _await$this$callbacks2 !== void 0 ? _await$this$callbacks2 : []);
        }
        result = [...result, ...dynamicItems];
      } else {
        result = [...result, suggestion];
      }
    }
    return result;
  }
  async provideCompletionItems(model, position) {
    const lines = model.getLineCount();
    if (lines !== position.lineNumber || model.getLineContent(position.lineNumber).trimEnd().length >= position.column) {
      return emptyCompletionList;
    }
    const worker = await this.worker(model.uri);
    const wordInfo = model.getWordUntilPosition(position);
    const providedSuggestions = await worker.provideAutocompleteSuggestions(model.uri.toString(), {
      word: wordInfo.word,
      line: position.lineNumber,
      index: position.column
    });
    const withDynamicItems = providedSuggestions ? await this.injectDynamicAutocompleteItems(providedSuggestions.suggestions, {
      word: wordInfo.word,
      userDefinedVariables: providedSuggestions.userDefinedVariables
    }) : [];
    return {
      incomplete: true,
      suggestions: withDynamicItems.map(i => ({
        ...i,
        range: {
          startLineNumber: position.lineNumber,
          endLineNumber: position.lineNumber,
          startColumn: wordInfo.startColumn,
          endColumn: wordInfo.endColumn
        }
      }))
    };
  }
}
exports.ESQLCompletionAdapter = ESQLCompletionAdapter;