"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeepLinks = getDeepLinks;
var _i18n = require("@kbn/i18n");
var _locator = require("../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OVERVIEW_LINK_DEEP_LINK = {
  id: 'overview',
  title: _i18n.i18n.translate('xpack.ml.deepLink.overview', {
    defaultMessage: 'Overview'
  }),
  path: `/${_locator.ML_PAGES.OVERVIEW}`
};
const ANOMALY_DETECTION_DEEP_LINK = {
  id: 'anomalyDetection',
  title: _i18n.i18n.translate('xpack.ml.deepLink.anomalyDetection', {
    defaultMessage: 'Anomaly Detection'
  }),
  path: `/${_locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE}`,
  deepLinks: [{
    id: 'anomalyExplorer',
    title: _i18n.i18n.translate('xpack.ml.deepLink.anomalyExplorer', {
      defaultMessage: 'Anomaly explorer'
    }),
    path: `/${_locator.ML_PAGES.ANOMALY_EXPLORER}`
  }, {
    id: 'singleMetricViewer',
    title: _i18n.i18n.translate('xpack.ml.deepLink.singleMetricViewer', {
      defaultMessage: 'Single metric viewer'
    }),
    path: `/${_locator.ML_PAGES.SINGLE_METRIC_VIEWER}`
  }]
};
const DATA_FRAME_ANALYTICS_DEEP_LINK = {
  id: 'dataFrameAnalytics',
  title: _i18n.i18n.translate('xpack.ml.deepLink.dataFrameAnalytics', {
    defaultMessage: 'Data Frame Analytics'
  }),
  path: `/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE}`,
  deepLinks: [{
    id: 'resultExplorer',
    title: _i18n.i18n.translate('xpack.ml.deepLink.resultExplorer', {
      defaultMessage: 'Results explorer'
    }),
    path: `/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION}`
  }, {
    id: 'analyticsMap',
    title: _i18n.i18n.translate('xpack.ml.deepLink.analyticsMap', {
      defaultMessage: 'Analytics map'
    }),
    path: `/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP}`
  }]
};
const AIOPS_DEEP_LINK = {
  id: 'aiOps',
  title: _i18n.i18n.translate('xpack.ml.deepLink.aiOps', {
    defaultMessage: 'AIOps'
  }),
  // Default to the index select page for the explain log rate spikes since we don't have an AIops overview page
  path: `/${_locator.ML_PAGES.AIOPS_EXPLAIN_LOG_RATE_SPIKES_INDEX_SELECT}`,
  deepLinks: [{
    id: 'explainLogRateSpikes',
    title: _i18n.i18n.translate('xpack.ml.deepLink.explainLogRateSpikes', {
      defaultMessage: 'Explain Log Rate Spikes'
    }),
    path: `/${_locator.ML_PAGES.AIOPS_EXPLAIN_LOG_RATE_SPIKES_INDEX_SELECT}`
  }, {
    id: 'logPatternAnalysis',
    title: _i18n.i18n.translate('xpack.ml.deepLink.logPatternAnalysis', {
      defaultMessage: 'Log Pattern Analysis'
    }),
    path: `/${_locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION_INDEX_SELECT}`
  }, {
    id: 'changePointDetections',
    title: _i18n.i18n.translate('xpack.ml.deepLink.changePointDetection', {
      defaultMessage: 'Change Point Detection'
    }),
    path: `/${_locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION_INDEX_SELECT}`
  }]
};
const MODEL_MANAGEMENT_DEEP_LINK = {
  id: 'modelManagement',
  title: _i18n.i18n.translate('xpack.ml.deepLink.modelManagement', {
    defaultMessage: 'Model Management'
  }),
  path: `/${_locator.ML_PAGES.TRAINED_MODELS_MANAGE}`,
  deepLinks: [{
    id: 'nodesOverview',
    title: _i18n.i18n.translate('xpack.ml.deepLink.trainedModels', {
      defaultMessage: 'Trained Models'
    }),
    path: `/${_locator.ML_PAGES.TRAINED_MODELS_MANAGE}`
  }, {
    id: 'nodes',
    title: _i18n.i18n.translate('xpack.ml.deepLink.nodes', {
      defaultMessage: 'Nodes'
    }),
    path: `/${_locator.ML_PAGES.NODES}`
  }]
};
const MEMORY_USAGE_DEEP_LINK = {
  id: 'memoryUsage',
  title: _i18n.i18n.translate('xpack.ml.deepLink.memoryUsage', {
    defaultMessage: 'Memory Usage'
  }),
  path: `/${_locator.ML_PAGES.MEMORY_USAGE}`
};
const DATA_VISUALIZER_DEEP_LINK = {
  id: 'dataVisualizer',
  title: _i18n.i18n.translate('xpack.ml.deepLink.dataVisualizer', {
    defaultMessage: 'Data Visualizer'
  }),
  path: `/${_locator.ML_PAGES.DATA_VISUALIZER}`
};
const FILE_UPLOAD_DEEP_LINK = {
  id: 'fileUpload',
  title: _i18n.i18n.translate('xpack.ml.deepLink.fileUpload', {
    defaultMessage: 'File Upload'
  }),
  keywords: ['CSV', 'JSON'],
  path: `/${_locator.ML_PAGES.DATA_VISUALIZER_FILE}`
};
const INDEX_DATA_VISUALIZER_DEEP_LINK = {
  id: 'indexDataVisualizer',
  title: _i18n.i18n.translate('xpack.ml.deepLink.indexDataVisualizer', {
    defaultMessage: 'Index Data Visualizer'
  }),
  path: `/${_locator.ML_PAGES.DATA_VISUALIZER_INDEX_SELECT}`
};
const SETTINGS_DEEP_LINK = {
  id: 'settings',
  title: _i18n.i18n.translate('xpack.ml.deepLink.settings', {
    defaultMessage: 'Settings'
  }),
  path: `/${_locator.ML_PAGES.SETTINGS}`,
  deepLinks: [{
    id: 'calendarSettings',
    title: _i18n.i18n.translate('xpack.ml.deepLink.calendarSettings', {
      defaultMessage: 'Calendars'
    }),
    path: `/${_locator.ML_PAGES.CALENDARS_MANAGE}`
  }, {
    id: 'filterListsSettings',
    title: _i18n.i18n.translate('xpack.ml.deepLink.filterListsSettings', {
      defaultMessage: 'Filter Lists'
    }),
    path: `/${_locator.ML_PAGES.SETTINGS}` // Link to settings page as read only users cannot view filter lists.
  }]
};

const NOTIFICATIONS_DEEP_LINK = {
  id: 'notifications',
  title: _i18n.i18n.translate('xpack.ml.deepLink.notifications', {
    defaultMessage: 'Notifications'
  }),
  path: `/${_locator.ML_PAGES.NOTIFICATIONS}`
};
function getDeepLinks(isFullLicense) {
  const deepLinks = [DATA_VISUALIZER_DEEP_LINK, FILE_UPLOAD_DEEP_LINK, INDEX_DATA_VISUALIZER_DEEP_LINK];
  if (isFullLicense === true) {
    deepLinks.push(OVERVIEW_LINK_DEEP_LINK, ANOMALY_DETECTION_DEEP_LINK, DATA_FRAME_ANALYTICS_DEEP_LINK, MODEL_MANAGEMENT_DEEP_LINK, MEMORY_USAGE_DEEP_LINK, SETTINGS_DEEP_LINK, AIOPS_DEEP_LINK, NOTIFICATIONS_DEEP_LINK);
  }
  return deepLinks;
}