"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _public = require("@kbn/core/public");
var _management = require("./application/management");
var _locator = require("./locator");
var _dependency_cache = require("./application/util/dependency_cache");
var _register_feature = require("./register_feature");
var _license = require("../common/license");
var _app = require("../common/constants/app");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class MlPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "locator", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, pluginsSetup) {
    core.application.register({
      id: _app.PLUGIN_ID,
      title: _i18n.i18n.translate('xpack.ml.plugin.title', {
        defaultMessage: 'Machine Learning'
      }),
      order: 5000,
      euiIconType: _app.PLUGIN_ICON_SOLUTION,
      appRoute: '/app/ml',
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      updater$: this.appUpdater$,
      mount: async params => {
        const [coreStart, pluginsStart] = await core.getStartServices();
        const kibanaVersion = this.initializerContext.env.packageInfo.version;
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/app')));
        return renderApp(coreStart, {
          charts: pluginsStart.charts,
          data: pluginsStart.data,
          unifiedSearch: pluginsStart.unifiedSearch,
          dashboard: pluginsStart.dashboard,
          share: pluginsStart.share,
          security: pluginsStart.security,
          licensing: pluginsStart.licensing,
          management: pluginsSetup.management,
          licenseManagement: pluginsSetup.licenseManagement,
          home: pluginsSetup.home,
          embeddable: {
            ...pluginsSetup.embeddable,
            ...pluginsStart.embeddable
          },
          maps: pluginsStart.maps,
          uiActions: pluginsStart.uiActions,
          kibanaVersion,
          triggersActionsUi: pluginsStart.triggersActionsUi,
          dataVisualizer: pluginsStart.dataVisualizer,
          usageCollection: pluginsSetup.usageCollection,
          fieldFormats: pluginsStart.fieldFormats,
          lens: pluginsStart.lens,
          cases: pluginsStart.cases,
          savedObjectsManagement: pluginsStart.savedObjectsManagement,
          savedSearch: pluginsStart.savedSearch
        }, params);
      }
    });
    if (pluginsSetup.share) {
      this.locator = pluginsSetup.share.url.locators.create(new _locator.MlLocatorDefinition());
    }
    if (pluginsSetup.management) {
      (0, _management.registerManagementSection)(pluginsSetup.management, core, {
        usageCollection: pluginsSetup.usageCollection
      }).enable();
    }
    const licensing = pluginsSetup.licensing.license$.pipe((0, _operators.take)(1));
    licensing.subscribe(async license => {
      const mlEnabled = (0, _license.isMlEnabled)(license);
      const fullLicense = (0, _license.isFullLicense)(license);
      const [coreStart, pluginStart] = await core.getStartServices();
      const {
        capabilities
      } = coreStart.application;
      if (mlEnabled) {
        // add ML to home page
        if (pluginsSetup.home) {
          (0, _register_feature.registerFeature)(pluginsSetup.home);
        }
      } else {
        // if ml is disabled in elasticsearch, disable ML in kibana
        this.appUpdater$.next(() => ({
          status: _public.AppStatus.inaccessible
        }));
      }

      // register various ML plugin features which require a full license
      // note including registerFeature in register_helper would cause the page bundle size to increase significantly
      const {
        registerEmbeddables,
        registerMlUiActions,
        registerSearchLinks,
        registerMlAlerts,
        registerMapExtension,
        registerCasesAttachments
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./register_helper')));
      if (pluginsSetup.maps) {
        var _capabilities$ml, _capabilities$ml2;
        // Pass capabilites.ml.canGetJobs as minimum permission to show anomalies card in maps layers
        const canGetJobs = ((_capabilities$ml = capabilities.ml) === null || _capabilities$ml === void 0 ? void 0 : _capabilities$ml.canGetJobs) === true;
        const canCreateJobs = ((_capabilities$ml2 = capabilities.ml) === null || _capabilities$ml2 === void 0 ? void 0 : _capabilities$ml2.canCreateJob) === true;
        await registerMapExtension(pluginsSetup.maps, core, {
          canGetJobs,
          canCreateJobs
        });
      }
      if (mlEnabled) {
        registerSearchLinks(this.appUpdater$, fullLicense);
        if (fullLicense) {
          var _capabilities$ml3;
          registerEmbeddables(pluginsSetup.embeddable, core);
          registerMlUiActions(pluginsSetup.uiActions, core);
          if (pluginsSetup.cases) {
            registerCasesAttachments(pluginsSetup.cases, coreStart, pluginStart);
          }
          const canUseMlAlerts = (_capabilities$ml3 = capabilities.ml) === null || _capabilities$ml3 === void 0 ? void 0 : _capabilities$ml3.canUseMlAlerts;
          if (pluginsSetup.triggersActionsUi && canUseMlAlerts) {
            registerMlAlerts(pluginsSetup.triggersActionsUi, pluginsSetup.alerting);
          }
        }
      }
    });
    return {
      locator: this.locator
    };
  }
  start(core, deps) {
    (0, _dependency_cache.setDependencyCache)({
      docLinks: core.docLinks,
      basePath: core.http.basePath,
      http: core.http,
      i18n: core.i18n,
      lens: deps.lens
    });
    return {
      locator: this.locator
    };
  }
  stop() {}
}
exports.MlPlugin = MlPlugin;