"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyChartsEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _app = require("../../../common/constants/app");
var _http_service = require("../../application/services/http_service");
var _ = require("..");
var _anomaly_explorer_charts_service = require("../../application/services/anomaly_explorer_charts_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class AnomalyChartsEmbeddableFactory {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE);
    (0, _defineProperty2.default)(this, "grouping", [{
      id: _app.PLUGIN_ID,
      getDisplayName: () => _app.ML_APP_NAME,
      getIconType: () => _app.PLUGIN_ICON
    }]);
    this.getStartServices = getStartServices;
  }
  async isEditable() {
    return true;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.ml.components.mlAnomalyExplorerEmbeddable.displayName', {
      defaultMessage: 'Anomaly chart'
    });
  }
  getDescription() {
    return _i18n.i18n.translate('xpack.ml.components.mlAnomalyExplorerEmbeddable.description', {
      defaultMessage: 'View anomaly detection results in a chart.'
    });
  }
  async getExplicitInput() {
    const [coreStart] = await this.getServices();
    try {
      const {
        resolveEmbeddableAnomalyChartsUserInput
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_charts_setup_flyout')));
      return await resolveEmbeddableAnomalyChartsUserInput(coreStart);
    } catch (e) {
      return Promise.reject();
    }
  }
  async getServices() {
    const [coreStart, pluginsStart] = await this.getStartServices();
    const {
      AnomalyDetectorService
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/anomaly_detector_service')));
    const {
      mlApiServicesProvider
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/ml_api_service')));
    const {
      mlResultsServiceProvider
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/results_service')));
    const httpService = new _http_service.HttpService(coreStart.http);
    const anomalyDetectorService = new AnomalyDetectorService(httpService);
    const mlApiServices = mlApiServicesProvider(httpService);
    const mlResultsService = mlResultsServiceProvider(mlApiServices);
    const anomalyExplorerService = new _anomaly_explorer_charts_service.AnomalyExplorerChartsService(pluginsStart.data.query.timefilter.timefilter, mlApiServices, mlResultsService);
    return [coreStart, pluginsStart, {
      anomalyDetectorService,
      anomalyExplorerService,
      mlResultsService
    }];
  }
  async create(initialInput, parent) {
    const services = await this.getServices();
    const {
      AnomalyChartsEmbeddable
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_charts_embeddable')));
    return new AnomalyChartsEmbeddable(initialInput, services, parent);
  }
}
exports.AnomalyChartsEmbeddableFactory = AnomalyChartsEmbeddableFactory;