"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractDeploymentId = extractDeploymentId;
exports.getCloudDeploymentId = getCloudDeploymentId;
exports.getCloudId = getCloudId;
exports.getNewJobDefaults = getNewJobDefaults;
exports.getNewJobLimits = getNewJobLimits;
exports.isCloud = isCloud;
exports.isCloudTrial = isCloudTrial;
exports.loadMlServerInfo = loadMlServerInfo;
var _ml_api_service = require("./ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let defaults = {
  anomaly_detectors: {},
  datafeeds: {}
};
let limits = {};
const cloudInfo = {
  cloudId: null,
  isCloud: false,
  isCloudTrial: false,
  deploymentId: null
};
async function loadMlServerInfo() {
  try {
    var _resp$cloudId;
    const resp = await _ml_api_service.ml.mlInfo();
    defaults = resp.defaults;
    limits = resp.limits;
    cloudInfo.cloudId = (_resp$cloudId = resp.cloudId) !== null && _resp$cloudId !== void 0 ? _resp$cloudId : null;
    cloudInfo.isCloud = resp.cloudId !== undefined;
    cloudInfo.isCloudTrial = resp.isCloudTrial === true;
    cloudInfo.deploymentId = !resp.cloudId ? null : extractDeploymentId(resp.cloudId);
    return {
      defaults,
      limits,
      cloudId: cloudInfo
    };
  } catch (error) {
    return {
      defaults,
      limits,
      cloudId: cloudInfo
    };
  }
}
function getNewJobDefaults() {
  return defaults;
}
function getNewJobLimits() {
  return limits;
}
function getCloudId() {
  return cloudInfo.cloudId;
}
function isCloud() {
  return cloudInfo.isCloud;
}
function isCloudTrial() {
  return cloudInfo.isCloudTrial;
}
function getCloudDeploymentId() {
  return cloudInfo.deploymentId;
}
function extractDeploymentId(cloudId) {
  const tempCloudId = cloudId.replace(/^(.+)?:/, '');
  try {
    const matches = atob(tempCloudId).match(/^.+\$(.+)(?=\$)/);
    return matches !== null && matches.length === 2 ? matches[1] : null;
  } catch (error) {
    return null;
  }
}