"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpService = void 0;
exports.http = http;
exports.http$ = http$;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _dependency_cache = require("../util/dependency_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getResultHeaders(headers) {
  return {
    'Content-Type': 'application/json',
    ...headers
  };
}
function getFetchOptions(options) {
  const {
    path,
    method,
    headers,
    body,
    query,
    version
  } = options;
  if (!path) {
    throw new Error('URL path is missing');
  }
  const fetchOptions = {
    asSystemRequest: true,
    credentials: 'same-origin',
    method: method || 'GET',
    headers: getResultHeaders(headers !== null && headers !== void 0 ? headers : {})
  };
  if (body) {
    fetchOptions.body = body;
  }
  if (query) {
    fetchOptions.query = query;
  }
  if (version) {
    fetchOptions.version = version;
  }
  return {
    path,
    fetchOptions
  };
}

/**
 * Function for making HTTP requests to Kibana's backend.
 * Wrapper for Kibana's HttpHandler.
 *
 * @deprecated use {@link HttpService} instead
 */
async function http(options) {
  const {
    path,
    fetchOptions
  } = getFetchOptions(options);
  return (0, _dependency_cache.getHttp)().fetch(path, fetchOptions);
}

/**
 * Function for making HTTP requests to Kibana's backend which returns an Observable
 * with request cancellation support.
 *
 * @deprecated use {@link HttpService} instead
 */
function http$(options) {
  const {
    path,
    fetchOptions
  } = getFetchOptions(options);
  return fromHttpHandler(path, fetchOptions);
}

/**
 * Creates an Observable from Kibana's HttpHandler.
 */
function fromHttpHandler(input, init) {
  return new _rxjs.Observable(subscriber => {
    const controller = new AbortController();
    const signal = controller.signal;
    let abortable = true;
    let unsubscribed = false;
    if (init !== null && init !== void 0 && init.signal) {
      if (init.signal.aborted) {
        controller.abort();
      } else {
        init.signal.addEventListener('abort', () => {
          if (!signal.aborted) {
            controller.abort();
          }
        });
      }
    }
    const perSubscriberInit = {
      ...(init ? init : {}),
      signal
    };
    (0, _dependency_cache.getHttp)().fetch(input, perSubscriberInit).then(response => {
      abortable = false;
      subscriber.next(response);
      subscriber.complete();
    }).catch(err => {
      abortable = false;
      if (!unsubscribed) {
        subscriber.error(err);
      }
    });
    return () => {
      unsubscribed = true;
      if (abortable) {
        controller.abort();
      }
    };
  });
}

/**
 * ML Http Service
 */
class HttpService {
  constructor(httpStart) {
    (0, _defineProperty2.default)(this, "getLoadingCount$", void 0);
    this.httpStart = httpStart;
    this.getLoadingCount$ = httpStart.getLoadingCount$();
  }

  /**
   * Creates an Observable from Kibana's HttpHandler.
   */
  fromHttpHandler(input, init) {
    return new _rxjs.Observable(subscriber => {
      const controller = new AbortController();
      const signal = controller.signal;
      let abortable = true;
      let unsubscribed = false;
      if (init !== null && init !== void 0 && init.signal) {
        if (init.signal.aborted) {
          controller.abort();
        } else {
          init.signal.addEventListener('abort', () => {
            if (!signal.aborted) {
              controller.abort();
            }
          });
        }
      }
      const perSubscriberInit = {
        ...(init ? init : {}),
        signal
      };
      this.httpStart.fetch(input, perSubscriberInit).then(response => {
        abortable = false;
        subscriber.next(response);
        subscriber.complete();
      }).catch(err => {
        abortable = false;
        if (!unsubscribed) {
          subscriber.error(err);
        }
      });
      return () => {
        unsubscribed = true;
        if (abortable) {
          controller.abort();
        }
      };
    });
  }

  /**
   * Function for making HTTP requests to Kibana's backend.
   * Wrapper for Kibana's HttpHandler.
   */
  async http(options) {
    const {
      path,
      fetchOptions
    } = getFetchOptions(options);
    return this.httpStart.fetch(path, fetchOptions);
  }

  /**
   * Function for making HTTP requests to Kibana's backend which returns an Observable
   * with request cancellation support.
   */
  http$(options) {
    const {
      path,
      fetchOptions
    } = getFetchOptions(options);
    return this.fromHttpHandler(path, fetchOptions);
  }
}
exports.HttpService = HttpService;