"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.recognizeRouteFactory = exports.checkViewOrCreateRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _queryString = require("query-string");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _resolvers = require("../../resolvers");
var _locator = require("../../../../locator");
var _kibana = require("../../../contexts/kibana");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _recognize = require("../../../jobs/new_job/recognize");
var _job_service = require("../../../services/job_service");
var _breadcrumbs = require("../../breadcrumbs");
var _use_create_ad_links = require("../../../components/custom_hooks/use_create_ad_links");
var _ml = require("../../../contexts/ml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const recognizeRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_RECOGNIZER),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ANOMALY_DETECTION_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('CREATE_JOB_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.selectIndexOrSearchLabelRecognize', {
      defaultMessage: 'Recognized index'
    }),
    href: ''
  }]
});
exports.recognizeRouteFactory = recognizeRouteFactory;
const checkViewOrCreateRouteFactory = () => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_MODULES_VIEW_OR_CREATE),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(CheckViewOrCreateWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  // no breadcrumbs since it's just a redirect
  breadcrumbs: []
});
exports.checkViewOrCreateRouteFactory = checkViewOrCreateRouteFactory;
const PageWrapper = ({
  location
}) => {
  const {
    id
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    context,
    results
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs'], {
    ...(0, _resolvers.basicResolvers)(),
    existingJobsAndGroups: _job_service.mlJobService.getJobAndGroupIds
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_ml.DataSourceContextProvider, null, results ? /*#__PURE__*/_react.default.createElement(_recognize.Page, {
    moduleId: id,
    existingGroupIds: results.existingJobsAndGroups.groupIds
  }) : null));
};
const CheckViewOrCreateWrapper = ({
  location
}) => {
  const {
    services: {
      notifications: {
        toasts
      },
      mlServices: {
        mlApiServices
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    id: moduleId,
    index: dataViewId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    createLinkWithUserDefaults
  } = (0, _use_create_ad_links.useCreateADLinks)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();

  /**
   * Checks whether the jobs in a data recognizer module have been created.
   * Redirects to the Anomaly Explorer to view the jobs if they have been created,
   * or the recognizer job wizard for the module if not.
   */
  function checkViewOrCreateJobs() {
    return new Promise((resolve, reject) => {
      // Load the module, and check if the job(s) in the module have been created.
      // If so, load the jobs in the Anomaly Explorer.
      // Otherwise open the data recognizer wizard for the module.
      // Always want to call reject() so as not to load original page.
      mlApiServices.dataRecognizerModuleJobsExist({
        moduleId
      }).then(async resp => {
        if (resp.jobsExist === true) {
          // also honor user's time filter setting in Advanced Settings
          const url = createLinkWithUserDefaults('explorer', resp.jobs);
          await navigateToPath(url);
          reject();
        } else {
          await navigateToPath(`/jobs/new_job/recognize?id=${moduleId}&index=${dataViewId}`);
          reject();
        }
      }).catch(async err => {
        // eslint-disable-next-line no-console
        console.error(`Error checking whether jobs in module ${moduleId} exists`, err);
        toasts.addWarning({
          title: _i18n.i18n.translate('xpack.ml.newJob.recognize.moduleCheckJobsExistWarningTitle', {
            defaultMessage: 'Error checking module {moduleId}',
            values: {
              moduleId
            }
          }),
          text: _i18n.i18n.translate('xpack.ml.newJob.recognize.moduleCheckJobsExistWarningDescription', {
            defaultMessage: 'An error occurred trying to check whether the jobs in the module have been created.'
          })
        });
        await navigateToPath(`/jobs`);
        reject();
      });
    });
  }
  (0, _use_resolver.useRouteResolver)('full', ['canCreateJob'], {
    checkViewOrCreateJobs
  });
  return null;
};