"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobListRouteFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _locator = require("../../../locator");
var _jobs_list = require("../../../../common/constants/jobs_list");
var _router = require("../router");
var _use_resolver = require("../use_resolver");
var _jobs_list2 = require("../../jobs/jobs_list");
var _breadcrumbs = require("../breadcrumbs");
var _annotations_service = require("../../services/annotations_service");
var _ml_annotation_updates_context = require("../../contexts/ml/ml_annotation_updates_context");
var _resolvers = require("../resolvers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const jobListRouteFactory = (navigateToPath, basePath) => ({
  id: 'anomaly_detection',
  title: _i18n.i18n.translate('xpack.ml.anomalyDetection.jobs.docTitle', {
    defaultMessage: 'Anomaly Detection Jobs'
  }),
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ANOMALY_DETECTION_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.anomalyDetection.jobsManagementLabel', {
      defaultMessage: 'Jobs'
    })
  }],
  'data-test-subj': 'mlPageJobManagement',
  enableDatePicker: true
});
exports.jobListRouteFactory = jobListRouteFactory;
const PageWrapper = () => {
  var _mlTimefilterRefresh$, _refresh$value, _refresh$pause;
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs'], (0, _resolvers.basicResolvers)());
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: true
  });
  const refresh = (0, _mlDatePicker.useRefreshIntervalUpdates)();
  const mlTimefilterRefresh = (0, _useObservable.default)(_mlDatePicker.mlTimefilterRefresh$);
  const lastRefresh = (_mlTimefilterRefresh$ = mlTimefilterRefresh === null || mlTimefilterRefresh === void 0 ? void 0 : mlTimefilterRefresh.lastRefresh) !== null && _mlTimefilterRefresh$ !== void 0 ? _mlTimefilterRefresh$ : 0;
  const refreshValue = (_refresh$value = refresh.value) !== null && _refresh$value !== void 0 ? _refresh$value : 0;
  const refreshPause = (_refresh$pause = refresh.pause) !== null && _refresh$pause !== void 0 ? _refresh$pause : true;
  (0, _react.useEffect)(() => {
    const refreshInterval = refreshValue === 0 || refreshPause === true ? {
      pause: false,
      value: _jobs_list.DEFAULT_REFRESH_INTERVAL_MS
    } : {
      pause: refreshPause,
      value: refreshValue
    };
    timefilter.setRefreshInterval(refreshInterval);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const annotationUpdatesService = (0, _react.useMemo)(() => new _annotations_service.AnnotationUpdatesService(), []);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_ml_annotation_updates_context.MlAnnotationUpdatesContext.Provider, {
    value: annotationUpdatesService
  }, /*#__PURE__*/_react.default.createElement(_jobs_list2.JobsPage, {
    lastRefresh: lastRefresh
  })));
};