"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.explainLogRateSpikesRouteFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/aiops-plugin/common");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _explain_log_rate_spikes = require("../../../aiops/explain_log_rate_spikes");
var _breadcrumbs = require("../../breadcrumbs");
var _ml = require("../../../contexts/ml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const explainLogRateSpikesRouteFactory = (navigateToPath, basePath) => ({
  id: 'explain_log_rate_spikes',
  path: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_EXPLAIN_LOG_RATE_SPIKES),
  title: _i18n.i18n.translate('xpack.ml.aiops.explainLogRateSpikes.docTitle', {
    defaultMessage: 'Explain log rate spikes'
  }),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('AIOPS_BREADCRUMB_EXPLAIN_LOG_RATE_SPIKES', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbs.explainLogRateSpikesLabel', {
      defaultMessage: 'Explain log rate spikes'
    })
  }],
  disabled: !_common.AIOPS_ENABLED
});
exports.explainLogRateSpikesRouteFactory = explainLogRateSpikesRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canUseAiops']);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_ml.DataSourceContextProvider, null, /*#__PURE__*/_react.default.createElement(_explain_log_rate_spikes.ExplainLogRateSpikesPage, null)));
};