"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NerInference = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _inference_base = require("../inference_base");
var _text_input = require("../text_input");
var _ner_output = require("./ner_output");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class NerInference extends _inference_base.InferenceBase {
  constructor(trainedModelsApi, model, inputType, deploymentId) {
    super(trainedModelsApi, model, inputType, deploymentId);
    (0, _defineProperty2.default)(this, "inferenceType", _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.NER);
    (0, _defineProperty2.default)(this, "inferenceTypeLabel", _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.ner.label', {
      defaultMessage: 'Named entity recognition'
    }));
    (0, _defineProperty2.default)(this, "info", [_i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.ner.info1', {
      defaultMessage: 'Test how well the model identifies named entities in your input text.'
    })]);
    this.initialize();
  }
  async inferText() {
    return this.runInfer(() => {}, (resp, inputText) => {
      return {
        response: parseResponse(resp),
        rawResponse: resp,
        inputText
      };
    });
  }
  async inferIndex() {
    return this.runPipelineSimulate(doc => {
      return {
        response: parseResponse({
          inference_results: [doc._source[this.inferenceType]]
        }),
        rawResponse: doc._source[this.inferenceType],
        inputText: doc._source[this.getInputField()]
      };
    });
  }
  getProcessors() {
    return this.getBasicProcessors();
  }
  getInputComponent() {
    if (this.inputType === _inference_base.INPUT_TYPE.TEXT) {
      const placeholder = _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.ner.inputText', {
        defaultMessage: 'Enter a phrase to test'
      });
      return (0, _text_input.getGeneralInputComponent)(this, placeholder);
    } else {
      return null;
    }
  }
  getOutputComponent() {
    return (0, _ner_output.getNerOutputComponent)(this);
  }
}
exports.NerInference = NerInference;
function parseResponse(resp) {
  const [{
    predicted_value: predictedValue,
    entities
  }] = resp.inference_results;
  const splitWordsAndEntitiesRegex = /(\[.*?\]\(.*?&.*?\))/;
  const matchEntityRegex = /(\[.*?\])\((.*?)&(.*?)\)/;
  if (predictedValue === undefined || entities === undefined) {
    return [];
  }
  const sentenceChunks = predictedValue.split(splitWordsAndEntitiesRegex);
  let count = 0;
  return sentenceChunks.map(chunk => {
    const matchedEntity = chunk.match(matchEntityRegex);
    if (matchedEntity) {
      const entityValue = matchedEntity[3];
      const entity = entities[count];
      if (entityValue !== entity.entity && entityValue.replaceAll('+', ' ') !== entity.entity) {
        // entityValue may not equal entity.entity if the entity is comprised of
        // two words as they are joined with a plus symbol
        // Replace any plus symbols and check again. If they still don't match, log an error

        // eslint-disable-next-line no-console
        console.error('mismatch entity', entity);
      }
      count++;
      return {
        value: entity.entity,
        entity
      };
    }
    return {
      value: chunk,
      entity: null
    };
  });
}