"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelPipelines = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../contexts/kibana");
var _expanded_row = require("./expanded_row");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ModelPipelines = ({
  pipelines,
  ingestStats
}) => {
  var _ref;
  const {
    services: {
      share
    }
  } = (0, _kibana.useMlKibana)();
  const pipelineNames = Object.keys((_ref = pipelines !== null && pipelines !== void 0 ? pipelines : ingestStats === null || ingestStats === void 0 ? void 0 : ingestStats.pipelines) !== null && _ref !== void 0 ? _ref : {});
  if (!pipelineNames.length) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, pipelineNames.map((pipelineName, i) => {
    var _pipelines$pipelineNa, _pipelines$pipelineNa2;
    // Expand first 3 pipelines by default
    const initialIsOpen = i <= 2;
    const pipelineDefinition = pipelines === null || pipelines === void 0 ? void 0 : pipelines[pipelineName];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: pipelineName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: pipelineName,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h5", null, pipelineName)),
      extraAction: pipelineDefinition ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": `mlTrainedModelPipelineEditButton_${pipelineName}`,
        onClick: () => {
          const locator = share.url.locators.get('INGEST_PIPELINES_APP_LOCATOR');
          if (!locator) return;
          locator.navigate({
            page: 'pipeline_edit',
            pipelineId: pipelineName,
            absolute: true
          });
        },
        iconType: 'documentEdit',
        iconSide: "left"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.editPipelineLabel",
        defaultMessage: "Edit"
      })) : undefined,
      paddingSize: "l",
      initialIsOpen: initialIsOpen
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      columns: 2
    }, (_pipelines$pipelineNa = ingestStats.pipelines[pipelineName]) !== null && _pipelines$pipelineNa !== void 0 && _pipelines$pipelineNa.processors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": `mlTrainedModelPipelineIngestStats_${pipelineName}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 'xxs'
    }, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.expandedRow.ingestStatsTitle",
      defaultMessage: "Ingest stats"
    }))), /*#__PURE__*/_react.default.createElement(_expanded_row.ProcessorsStats, {
      stats: (_pipelines$pipelineNa2 = ingestStats.pipelines[pipelineName]) === null || _pipelines$pipelineNa2 === void 0 ? void 0 : _pipelines$pipelineNa2.processors
    }))) : null, pipelineDefinition ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": `mlTrainedModelPipelineDefinition_${pipelineName}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 'xxs'
    }, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.expandedRow.processorsTitle",
      defaultMessage: "Definition"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      fontSize: "m",
      paddingSize: "m",
      overflowHeight: 300,
      isCopyable: true
    }, JSON.stringify(pipelineDefinition, null, 2)))) : null)));
  }));
};
exports.ModelPipelines = ModelPipelines;