"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _app = require("../../../../../../common/constants/app");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _access_denied_page = require("../access_denied_page");
var _insufficient_license_page = require("../insufficient_license_page");
var _job_spaces_sync = require("../../../../components/job_spaces_sync");
var _app2 = require("../../../../app");
var _import_export_jobs = require("../../../../components/import_export_jobs");
var _ml_api_service = require("../../../../services/ml_api_service");
var _http_service = require("../../../../services/http_service");
var _space_management = require("./space_management");
var _docs_link = require("./docs_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const JobsListPage = ({
  coreStart,
  share,
  history,
  spacesApi,
  data,
  usageCollection,
  fieldFormats
}) => {
  const mlApiServices = (0, _react.useMemo)(() => (0, _ml_api_service.mlApiServicesProvider)(new _http_service.HttpService(coreStart.http)), [coreStart.http]);
  const [initialized, setInitialized] = (0, _react.useState)(false);
  const [accessDenied, setAccessDenied] = (0, _react.useState)(false);
  const [isPlatinumOrTrialLicense, setIsPlatinumOrTrialLicense] = (0, _react.useState)(true);
  const [showSyncFlyout, setShowSyncFlyout] = (0, _react.useState)(false);
  const [currentTabId, setCurrentTabId] = (0, _react.useState)('anomaly-detector');
  const I18nContext = coreStart.i18n.Context;
  const theme$ = coreStart.theme.theme$;
  const check = async () => {
    try {
      await (0, _check_capabilities.checkGetManagementMlJobsResolver)(mlApiServices);
    } catch (e) {
      if (e.mlFeatureEnabledInSpace && e.isPlatinumOrTrialLicense === false) {
        setIsPlatinumOrTrialLicense(false);
      } else {
        setAccessDenied(true);
      }
    }
    setInitialized(true);
  };
  (0, _react.useEffect)(() => {
    check();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const ContextWrapper = (0, _react.useCallback)(spacesApi ? spacesApi.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spacesApi]);
  if (initialized === false) {
    return null;
  }
  function onCloseSyncFlyout() {
    setShowSyncFlyout(false);
  }
  if (accessDenied) {
    return /*#__PURE__*/_react.default.createElement(_access_denied_page.AccessDeniedPage, null);
  }
  if (isPlatinumOrTrialLicense === false) {
    return /*#__PURE__*/_react.default.createElement(_insufficient_license_page.InsufficientLicensePage, {
      basePath: coreStart.http.basePath
    });
  }
  return /*#__PURE__*/_react.default.createElement(_public.RedirectAppLinks, {
    application: coreStart.application
  }, /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      share,
      data,
      usageCollection,
      fieldFormats,
      spacesApi,
      mlServices: (0, _app2.getMlGlobalServices)(coreStart.http, usageCollection)
    }
  }, /*#__PURE__*/_react.default.createElement(ContextWrapper, {
    feature: _app.PLUGIN_ID
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.management.jobsList.jobsListTitle",
      defaultMessage: "Machine Learning"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.management.jobsList.jobsListTagline",
      defaultMessage: "View, export, and import machine learning analytics and anomaly detection items."
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_docs_link.DocsLink, {
      currentTabId: currentTabId
    })],
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentBody_Deprecated, {
    id: "kibanaManagementMLSection",
    "data-test-subj": "mlPageStackManagementJobsList"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setShowSyncFlyout(true),
    "data-test-subj": "mlStackMgmtSyncButton"
  }, _i18n.i18n.translate('xpack.ml.management.jobsList.syncFlyoutButton', {
    defaultMessage: 'Synchronize saved objects'
  })), showSyncFlyout && /*#__PURE__*/_react.default.createElement(_job_spaces_sync.JobSpacesSyncFlyout, {
    onClose: onCloseSyncFlyout
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_import_export_jobs.ExportJobsFlyout, {
    isDisabled: false,
    currentTab: currentTabId === 'trained-model' ? 'anomaly-detector' : currentTabId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_import_export_jobs.ImportJobsFlyout, {
    isDisabled: false
  }))), /*#__PURE__*/_react.default.createElement(_space_management.SpaceManagement, {
    spacesApi: spacesApi,
    setCurrentTab: setCurrentTabId
  }))))))));
};
exports.JobsListPage = JobsListPage;